/*
 * Decompiled with CFR 0.152.
 */
package Altibase.jdbc.driver;

import Altibase.jdbc.driver.ABEncoder;
import Altibase.jdbc.driver.ABPreparedStatement;
import Altibase.jdbc.driver.ABResultSet;
import Altibase.jdbc.driver.ABStatement;
import Altibase.jdbc.driver.ABString;
import Altibase.jdbc.driver.ABXAException;
import Altibase.jdbc.driver.BindMeta;
import Altibase.jdbc.driver.SQLStates;
import Altibase.jdbc.driver.XID;
import Altibase.jdbc.driver.cm;
import Altibase.jdbc.driver.cmb;
import Altibase.jdbc.driver.cmn;
import Altibase.jdbc.driver.cmnTCP;
import Altibase.jdbc.driver.cmo;
import Altibase.jdbc.driver.ex;
import Altibase.jdbc.driver.version;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

class cmp
implements SQLStates,
cm,
cmo {
    private byte any = 0;
    private byte mCurOpCode;
    private cmb cbr;
    private cmb cbw;
    private cmn chn;
    private ABEncoder coder;
    private int mTimeStamp = Integer.MAX_VALUE;
    private ABString param;
    private ByteBuffer tmp;
    private String sDBN;
    private String sCharset;
    private String sUID;
    private String sPWD;
    private int sTimeout;

    private cmp(cmn channel) throws SQLException {
        this.chn = channel;
        this.tmp = ByteBuffer.allocate(128);
    }

    private final void appendProperty(byte aPropertyId, byte aProperty) throws SQLException {
        this.next((byte)10);
        this.cbw.putShort(aPropertyId);
        this.cbw.putByte((byte)3);
        this.cbw.putByte(aProperty);
    }

    private final void appendProperty(byte aPropertyId, int aProperty) throws SQLException {
        this.next((byte)10);
        this.cbw.putShort(aPropertyId);
        this.cbw.putByte((byte)7);
        this.cbw.putInt(aProperty);
    }

    private final void appendProperty(byte aPropertyId, long aProperty) throws SQLException {
        this.next((byte)10);
        this.cbw.putShort(aPropertyId);
        this.cbw.putByte((byte)9);
        this.cbw.putLong(aProperty);
    }

    private final void appendProperty(byte aPropertyId, String aProperty) throws SQLException {
        this.param.set(aProperty);
        this.next((byte)10);
        this.cbw.putShort(aPropertyId);
        this.cbw.putByte((byte)15);
        this.param.write(this);
    }

    private final void begin(byte op) throws SQLException {
        this.cbr.init();
        this.cbw.begin();
        this.cbw.op(op);
        this.any = 0;
    }

    private final boolean check(byte brk) throws SQLException {
        SQLException e = null;
        byte op = this.op();
        while (op != brk) {
            switch (op) {
                case 46: {
                    break;
                }
                case 52: {
                    break;
                }
                case 55: {
                    break;
                }
                case 57: {
                    break;
                }
                case 44: {
                    break;
                }
                case 42: {
                    break;
                }
                case 5: {
                    break;
                }
                case 7: {
                    break;
                }
                case 11: {
                    break;
                }
                case 1: {
                    e = this.error(e);
                    break;
                }
                case 127: {
                    if (e != null) {
                        throw e;
                    }
                    return false;
                }
                default: {
                    ex.exception((short)30);
                }
            }
            op = this.op();
        }
        if (e != null) {
            throw e;
        }
        return op == brk;
    }

    private void dataout(ABStatement stmt) throws SQLException {
        this.cbr.intValue();
        short row = this.cbr.shortValue();
        short col = this.cbr.shortValue();
        BindMeta pm = ((ABPreparedStatement)stmt).param(col);
        pm.readDataFromCM(this, row);
    }

    private final SQLException error(SQLException e) throws SQLException {
        SQLException sex = null;
        byte mOperationID = this.cbr.get();
        short sErrorIndex = this.cbr.shortValue();
        int sErrorCode = this.cbr.intValue();
        String msg = this.getString();
        if ((sErrorCode & 0x2000000) == 0) {
            sex = ex.exception((short)27, "[" + sErrorIndex + "]:" + msg, sErrorCode >> 12);
            if (e == null) {
                e = sex;
            } else {
                e.setNextException(sex);
            }
        }
        return e;
    }

    private final long executeresult(ABStatement stmt) throws SQLException {
        this.any = 0;
        int sid = this.cbr.intValue();
        this.cbr = this.remain();
        short row = this.cbr.shortValue();
        this.cbr = this.remain();
        short scnt = this.cbr.shortValue();
        this.cbr = this.remain();
        if (stmt.size() != scnt) {
            stmt.setResultSetCount(scnt);
        }
        return this.cbr.longValue();
    }

    private final void fetchResultData(ABResultSet rs) throws SQLException {
        this.any = 0;
        rs.incFetchedColNumber();
        BindMeta bm = rs.getMetaColumn(rs.getFetchedColNumber());
        bm.readDataFromCM(this, rs.getFetchedRowNumber());
        if (rs.getFetchedColNumber() == rs.getColumnCount()) {
            rs.incFetchedRowNumber();
            rs.setFetchedColNumber((short)0);
        }
        this.any = 0;
    }

    private final void flush() throws SQLException {
        this.cbw.end();
        this.cbw = this.chn.send(this.cbw);
        this.cbr = this.chn.recv(this.cbr);
        this.mTimeStamp = (int)(System.currentTimeMillis() / 1000L + 1L);
    }

    private final void flushOnly() throws SQLException {
        this.cbw.end();
        this.cbw = this.chn.send(this.cbw);
        this.mTimeStamp = (int)(System.currentTimeMillis() / 1000L + 1L);
    }

    private final int get(byte[] buff, int aOffset) throws SQLException {
        boolean next = true;
        int r = 0;
        do {
            this.cbr = this.remain();
            int offset = aOffset + this.cbr.intValue();
            this.cbr = this.remain();
            short size = this.cbr.shortValue();
            this.cbr = this.remain();
            next = this.cbr.get() == 0;
            this.cbr = this.remain();
            this.cbr.getBytes(buff, offset, size);
            r += size;
        } while (next);
        return r;
    }

    private final int in_get(byte[] buff, int aOffset) throws SQLException {
        int size = 0;
        this.cbr = this.remain();
        size = this.cbr.intValue();
        this.cbr = this.remain();
        this.cbr.getBytes(buff, aOffset, size);
        return size;
    }

    private final void getcolresult(ABResultSet rs) throws SQLException {
        int sDataType = 0;
        int sid = this.cbr.intValue();
        short rid = this.cbr.shortValue();
        short col = this.cbr.shortValue();
        BindMeta bm = new BindMeta(col);
        bm.setInOutType((byte)4);
        sDataType = this.cbr.intValue();
        bm.setLanguage(this.cbr.intValue());
        bm.setArguments(this.cbr.get());
        int sPrecision = this.cbr.intValue();
        bm.setScale(this.cbr.intValue());
        bm.setNullableFlag(this.cbr.get());
        bm.mColumnName = this.getString();
        bm.setDataType(sDataType, sPrecision, sPrecision);
        bm.setEncoder(this.coder);
        rs.addMetaColumn(bm);
    }

    private final void getParamInfo(ABStatement stmt) throws SQLException {
        this.cbr = this.next();
        int id = this.cbr.intValue();
        short sParamNumber = this.cbr.shortValue();
        int sDataType = this.cbr.intValue();
        int sLanguage = this.cbr.intValue();
        byte sArguments = this.cbr.get();
        int sPrecision = this.cbr.intValue();
        int mScale = this.cbr.intValue();
        byte mInOutType = this.cbr.get();
        byte mNullableFlag = this.cbr.get();
    }

    private String getString() throws SQLException {
        this.param.read(this);
        return this.param.toString();
    }

    private final void handshake() throws SQLException {
        this.cbw = this.chn.alloc(new cmb());
        this.cbr = this.chn.alloc(new cmb());
        this.begin((byte)1);
        this.cbw.putByte((byte)1);
        this.cbw.putByte((byte)1);
        this.cbw.putByte((byte)4);
        this.flush();
        this.check((byte)1);
        this.cbr.get();
        this.cbw.setModuleID(this.cbr.get());
        this.cbw.setModuleVersion(this.cbr.get());
    }

    private final void put(String v) throws SQLException {
        this.param.set(v);
        this.param.write(this);
    }

    private final int result(ABResultSet rs) throws SQLException {
        int id = rs.getStatementID();
        short sv = 0;
        int i = 0;
        SQLException e = null;
        byte op = this.op();
        while (op != 127) {
            switch (op) {
                case 17: {
                    this.getcolresult(rs);
                    break;
                }
                case 20: {
                    break;
                }
                case 35: {
                    break;
                }
                case 37: {
                    id = this.cbr.intValue();
                    this.cbr = this.remain();
                    sv = this.cbr.shortValue();
                    rs.setState(1);
                    break;
                }
                case 38: {
                    this.fetchResultData(rs);
                    ++i;
                    break;
                }
                case 40: {
                    id = this.cbr.intValue();
                    this.cbr = this.remain();
                    sv = this.cbr.shortValue();
                    rs.setState(2);
                    break;
                }
                case 1: {
                    e = this.error(e);
                    break;
                }
                default: {
                    ex.exception((short)30);
                }
            }
            op = this.op();
        }
        if (e != null) {
            throw e;
        }
        return i > 0 ? i / rs.getColumnCount() : 0;
    }

    private final int result(ABStatement aStatement) throws SQLException {
        SQLException e = null;
        int rsc = 0;
        int i = 0;
        byte op = this.op();
        while (op != 127) {
            switch (op) {
                case 13: {
                    ++rsc;
                    this.rPrepare(aStatement);
                    break;
                }
                case 22: {
                    this.getParamInfo(aStatement);
                    break;
                }
                case 24: {
                    break;
                }
                case 28: {
                    this.dataout(aStatement);
                    break;
                }
                case 33: {
                    aStatement.setUpdateCount(this.executeresult(aStatement), rsc++);
                    break;
                }
                case 1: {
                    e = this.error(e);
                    aStatement.setUpdateCount(-3L, rsc++);
                    break;
                }
                case 0: {
                    aStatement.wn.warning((short)0, this.getString());
                    break;
                }
                case 17: {
                    this.getcolresult(aStatement.getDefaultResultSet());
                    break;
                }
                case 20: {
                    break;
                }
                case 35: {
                    break;
                }
                case 37: {
                    int sIntVal = this.cbr.intValue();
                    this.cbr = this.remain();
                    short sShortVal = this.cbr.shortValue();
                    aStatement.getDefaultResultSet().setState(1);
                    break;
                }
                case 38: {
                    this.fetchResultData(aStatement.getDefaultResultSet());
                    ++i;
                    break;
                }
                case 40: {
                    int sIntVal = this.cbr.intValue();
                    this.cbr = this.remain();
                    short sShortVal = this.cbr.shortValue();
                    if (e != null) break;
                    aStatement.getDefaultResultSet().setState(2);
                    break;
                }
                default: {
                    ex.exception((short)30);
                }
            }
            op = this.op();
        }
        if (e != null) {
            throw e;
        }
        if (i > 0) {
            aStatement.getDefaultResultSet().initFetchPosition(i / aStatement.getDefaultResultSet().getColumnCount());
            return i / aStatement.getDefaultResultSet().getColumnCount();
        }
        return rsc;
    }

    private final int rPrepare(ABStatement stmt) throws SQLException {
        stmt.setID(this.cbr.intValue());
        int sStmtType = this.cbr.intValue();
        stmt.setStmtType(sStmtType);
        short sParamsCount = this.cbr.shortValue();
        short sResultSetCount = this.cbr.shortValue();
        stmt.setResultSetCount(sResultSetCount);
        stmt.setParamsCount(sParamsCount);
        return sStmtType;
    }

    final void begin() throws SQLException {
        this.cbr.init();
        this.cbw.begin();
    }

    synchronized void cancel(int id) throws SQLException {
    }

    synchronized void close(ABResultSet rs) throws SQLException {
        this.begin((byte)41);
        this.cbw.putInt(rs.getStatementID());
        this.cbw.putShort(rs.getResultSetID());
        this.cbw.putByte((byte)0);
        this.flush();
        this.check((byte)42);
    }

    synchronized void connect(String aDBN, String charset, String aUID, String aPWD, int timeout) throws SQLException {
        this.sDBN = aDBN;
        this.sCharset = charset;
        this.sUID = aUID;
        this.sPWD = aPWD;
        this.sTimeout = timeout;
        this.coder = new ABEncoder(charset);
        this.param = new ABString(this.coder, 4096);
        if (!this.chn.isConnected()) {
            this.chn.connect(timeout);
            this.handshake();
        } else {
            this.chn.timeout(timeout);
        }
        this.begin((byte)4);
        this.put(aDBN);
        this.put(aUID);
        this.put(aPWD);
        this.cbw.putShort((short)0);
        this.appendProperty((byte)0, version.pkgVersion);
        this.appendProperty((byte)1, 0x5000400000004L);
        this.appendProperty((byte)2, Thread.currentThread().hashCode());
        this.appendProperty((byte)3, "JDBC");
        this.appendProperty((byte)10, 1);
        if (charset == null) {
            this.cbw.putByte((byte)8);
            this.cbw.putShort((short)5);
        }
        this.flush();
        if (this.check((byte)9)) {
            charset = (String)this.readProperty((short)5);
            this.coder = new ABEncoder(charset);
        }
        this.param.encoder(this.coder);
    }

    synchronized void disconnect(byte aOption) throws SQLException {
        this.begin((byte)6);
        this.cbw.putByte(aOption);
        this.flush();
        switch (aOption) {
            case 1: {
                if (this.cbr.get() == 7) break;
                this.chn.disconnect();
                ex.exception((short)29);
                break;
            }
            case 0: {
                this.chn.disconnect();
                break;
            }
            default: {
                ex.exception((short)106);
            }
        }
    }

    synchronized int exec(ABStatement stmt) throws SQLException {
        String sql = stmt.mQueryString;
        int stmtId = stmt.getID();
        while (true) {
            this.begin((byte)12);
            this.cbw.putInt(stmtId);
            this.put(sql);
            this.cbw.putByte((byte)0);
            if (stmtId == 0) {
                try {
                    this.flush();
                }
                catch (SQLException e) {
                    this.reconnect();
                    continue;
                }
                this.result(stmt);
                stmtId = stmt.getID();
                this.begin((byte)32);
            } else {
                this.next((byte)32);
            }
            this.cbw.putInt(stmtId);
            this.cbw.putShort((short)0);
            this.cbw.putByte((byte)1);
            try {
                this.flush();
            }
            catch (SQLException e) {
                this.reconnect();
                continue;
            }
            break;
        }
        return this.result(stmt);
    }

    synchronized int exec(ABPreparedStatement aStatement) throws SQLException {
        while (true) {
            this.begin();
            aStatement.bind(this);
            aStatement.write(this);
            this.next((byte)32);
            this.cbw.putInt(aStatement.getID());
            this.cbw.putShort((short)0);
            this.cbw.putByte((byte)1);
            try {
                this.flush();
            }
            catch (SQLException e) {
                this.reconnect();
                continue;
            }
            break;
        }
        return this.result(aStatement);
    }

    synchronized int writePrepareExecuteFetchReq(ABPreparedStatement aStatement) throws SQLException {
        int sStmtID = aStatement.getID();
        short sResultSetID = 0;
        short from = 1;
        short last = 0;
        short sFetchSize = (short)aStatement.getFetchSize();
        while (true) {
            this.begin();
            aStatement.bind(this);
            aStatement.write(this);
            this.next((byte)32);
            this.cbw.putInt(sStmtID);
            this.cbw.putShort((short)0);
            this.cbw.putByte((byte)1);
            if (aStatement.getDefaultResultSet().checkAndAllocateMeta()) {
                this.next((byte)16);
                this.cbw.putInt(sStmtID);
                this.cbw.putShort(sResultSetID);
                this.cbw.putShort((short)0);
            }
            this.next((byte)36);
            this.cbw.putInt(sStmtID);
            this.cbw.putShort(sResultSetID);
            this.cbw.putShort(sFetchSize);
            this.cbw.putShort(from);
            this.cbw.putShort(last);
            try {
                this.flush();
            }
            catch (SQLException e) {
                this.reconnect();
                continue;
            }
            break;
        }
        aStatement.getDefaultResultSet().setFetchedRowNumber(0);
        aStatement.getDefaultResultSet().setFetchedColNumber((short)0);
        aStatement.getDefaultResultSet().setMaxRows(aStatement.getMaxRows());
        aStatement.getDefaultResultSet().setFetchSize(aStatement.getFetchSize());
        return this.result(aStatement);
    }

    synchronized int writeDirectExecuteAndFetchReq(ABStatement aStatement) throws SQLException {
        String sSqlString = aStatement.mQueryString;
        int sStmtID = aStatement.getID();
        short sResultSetID = 0;
        short from = 1;
        short last = 0;
        short sFetchSize = (short)aStatement.getFetchSize();
        while (true) {
            this.begin((byte)12);
            this.cbw.putInt(sStmtID);
            this.put(sSqlString);
            this.cbw.putByte((byte)0);
            this.next((byte)32);
            this.cbw.putInt(sStmtID);
            this.cbw.putShort((short)0);
            this.cbw.putByte((byte)1);
            this.next((byte)16);
            this.cbw.putInt(sStmtID);
            this.cbw.putShort(sResultSetID);
            this.cbw.putShort((short)0);
            this.next((byte)36);
            this.cbw.putInt(sStmtID);
            this.cbw.putShort(sResultSetID);
            this.cbw.putShort(sFetchSize);
            this.cbw.putShort(from);
            this.cbw.putShort(last);
            try {
                this.flush();
            }
            catch (SQLException e) {
                this.reconnect();
                continue;
            }
            break;
        }
        return this.result(aStatement);
    }

    synchronized int execArray(ABPreparedStatement stmt) throws SQLException {
        int id = stmt.getID();
        short i = 0;
        short size = stmt.getBatchCount();
        while (true) {
            this.begin();
            stmt.bind(this);
            this.next((byte)32);
            this.cbw.putInt(id);
            this.cbw.putShort(i);
            this.cbw.putByte((byte)3);
            for (i = 0; i < size; i = (short)(i + 1)) {
                stmt.write(this);
                this.next((byte)32);
                this.cbw.putInt(id);
                this.cbw.putShort(i);
                this.cbw.putByte((byte)2);
            }
            this.next((byte)32);
            this.cbw.putInt(id);
            i = 0;
            this.cbw.putShort(i);
            this.cbw.putByte((byte)4);
            try {
                this.flush();
            }
            catch (SQLException e) {
                this.reconnect();
                continue;
            }
            break;
        }
        return this.result(stmt);
    }

    synchronized int writeFetchRequest(ABResultSet aResultSet) throws SQLException {
        int sStmtID = aResultSet.getStatementID();
        short sResultSetID = aResultSet.getResultSetID();
        short sFromPos = 1;
        short sToPos = 0;
        short sFetchSize = (short)aResultSet.getFetchSize();
        this.begin();
        if (aResultSet.checkAndAllocateMeta()) {
            this.next((byte)16);
            this.cbw.putInt(sStmtID);
            this.cbw.putShort(sResultSetID);
            this.cbw.putShort((short)0);
        }
        this.next((byte)36);
        this.cbw.putInt(sStmtID);
        this.cbw.putShort(sResultSetID);
        this.cbw.putShort(sFetchSize);
        this.cbw.putShort(sFromPos);
        this.cbw.putShort(sToPos);
        this.flush();
        aResultSet.initFetchedRowAndColNumber();
        return this.result(aResultSet);
    }

    synchronized void free(ABStatement aStatement) throws SQLException {
        int sStmtID = aStatement.getID();
        aStatement.setID(0);
        if (aStatement.getMoreResults() || sStmtID != 0) {
            this.begin((byte)41);
            this.cbw.putInt(sStmtID);
            this.cbw.putShort((short)-1);
            this.cbw.putByte((byte)1);
            this.flush();
            this.check((byte)42);
        }
    }

    final ByteBuffer get(ByteBuffer bb) throws SQLException {
        int offset = bb.position();
        int limit = this.get(bb.array(), offset) + offset;
        return (ByteBuffer)bb.limit(limit);
    }

    final ByteBuffer in_get(ByteBuffer bb) throws SQLException {
        int offset = bb.position();
        int limit = this.in_get(bb.array(), offset) + offset;
        return (ByteBuffer)bb.limit(limit);
    }

    final byte getAny() throws SQLException {
        this.cbr = this.remain();
        this.any = this.cbr.get();
        return this.any;
    }

    final ABEncoder getEncoder() {
        return this.coder;
    }

    final synchronized String getExplainPlan(int id) throws SQLException {
        this.begin((byte)14);
        this.cbw.putInt(id);
        this.flush();
        this.check((byte)15);
        ex.test(id != this.cbr.intValue(), (short)29);
        return this.getString();
    }

    synchronized Object getProperty(byte aPropertyId) throws SQLException {
        this.begin((byte)8);
        this.cbw.putShort(aPropertyId);
        this.flush();
        this.check((byte)9);
        return this.readProperty(aPropertyId);
    }

    synchronized ByteBuffer getQueryPlan(ABStatement stmt, ByteBuffer bb) throws SQLException {
        this.begin((byte)14);
        this.cbw.putInt(stmt.getID());
        this.flush();
        this.check((byte)15);
        ex.test(this.cbr.intValue() != stmt.getID(), (short)28);
        return this.get(bb);
    }

    final int getTimtStamp() {
        return this.mTimeStamp;
    }

    final ByteBuffer getTmpBuffer(int size) {
        if (size > this.tmp.capacity()) {
            this.tmp = ByteBuffer.allocate(size);
        }
        this.tmp.clear().limit(size);
        return this.tmp;
    }

    boolean isConnected() {
        return this.chn.isConnected();
    }

    synchronized void lobFree(long aLobLocator) throws SQLException {
        this.begin((byte)56);
        this.cbw.putLong(aLobLocator);
        this.flushOnly();
    }

    synchronized int lobGet(long aLobLocator, long aLobPosition, byte[] b, int aOffset, int length) throws SQLException {
        int v = 0;
        this.begin((byte)49);
        this.cbw.putLong(aLobLocator);
        this.cbw.putInt(aLobPosition);
        this.cbw.putInt(length);
        this.flush();
        int offset = aOffset;
        while (this.check((byte)50)) {
            ex.test(this.cbr.longValue() != aLobLocator, (short)28);
            this.cbr.intValue();
            v = this.get(b, offset);
            offset += v;
        }
        return offset - aOffset;
    }

    synchronized int lobGet2(long aLobLocator, long aBytePosition, byte[] aByteArr, int aOffset, int aCharLength, int[] aRetCharLength) throws SQLException {
        int sReadByteLength = 0;
        this.begin((byte)64);
        this.cbw.putLong(aLobLocator);
        this.cbw.putInt(aBytePosition);
        this.cbw.putInt(aCharLength);
        this.flush();
        aRetCharLength[0] = 0;
        int sOffset = aOffset;
        while (this.check((byte)65)) {
            ex.test(this.cbr.longValue() != aLobLocator, (short)28);
            this.cbr.intValue();
            aRetCharLength[0] = aRetCharLength[0] + this.cbr.intValue();
            sReadByteLength = this.get(aByteArr, sOffset);
            sOffset += sReadByteLength;
        }
        return sOffset - aOffset;
    }

    synchronized int lobGet3(long aLobLocator, long aCharPosition, byte[] aByteArr, int aOffset, int aCharLength, int[] aRetCharLength) throws SQLException {
        int sReadByteLength = 0;
        this.begin((byte)66);
        this.cbw.putLong(aLobLocator);
        this.cbw.putInt(aCharPosition);
        this.cbw.putInt(aCharLength);
        this.flush();
        aRetCharLength[0] = 0;
        int sOffset = aOffset;
        while (this.check((byte)65)) {
            ex.test(this.cbr.longValue() != aLobLocator, (short)28);
            this.cbr.intValue();
            aRetCharLength[0] = aRetCharLength[0] + this.cbr.intValue();
            sReadByteLength = this.get(aByteArr, sOffset);
            sOffset += sReadByteLength;
        }
        return sOffset - aOffset;
    }

    final synchronized long lobPut(long aLobLocator, long aLobPosition, long aLobLength, ByteBuffer aBuffer) throws SQLException {
        long writtenLength = 0L;
        long newSize = aLobPosition + (long)aBuffer.remaining() > aLobLength ? (long)aBuffer.remaining() : aLobLength - aLobPosition;
        this.begin((byte)51);
        this.cbw.putLong(aLobLocator);
        this.cbw.putInt(aLobPosition);
        this.cbw.putInt(aLobLength - aLobPosition);
        this.cbw.putInt(newSize);
        int sRemainedDataSize = aBuffer.remaining();
        int sCurrentPos = (int)aLobPosition;
        while (sRemainedDataSize > 0) {
            this.next((byte)53);
            this.cbw.putLong(aLobLocator);
            this.cbw.putInt(sCurrentPos);
            int sendDataSize = sRemainedDataSize > 32000 ? 32000 : sRemainedDataSize;
            aBuffer.limit(aBuffer.position() + sendDataSize);
            sCurrentPos += sendDataSize;
            sRemainedDataSize -= sendDataSize;
            this.putBufferWithSlice(aBuffer);
            writtenLength += (long)sendDataSize;
        }
        this.next((byte)54);
        this.cbw.putLong(aLobLocator);
        this.flush();
        this.check((byte)55);
        return writtenLength;
    }

    synchronized long lobSize(long aLobLocator) throws SQLException {
        long v = 0L;
        this.begin((byte)47);
        this.cbw.putLong(aLobLocator);
        this.flush();
        if (this.check((byte)48)) {
            ex.test(this.cbr.longValue() != aLobLocator, (short)28);
            v = this.cbr.intValue() >> 0;
        }
        return v;
    }

    synchronized long lobCharLength(long aLobLocator) throws SQLException {
        long v = 0L;
        this.begin((byte)69);
        this.cbw.putLong(aLobLocator);
        this.flush();
        if (this.check((byte)70)) {
            ex.test(this.cbr.longValue() != aLobLocator, (short)28);
            v = this.cbr.intValue() >> 0;
        }
        return v;
    }

    synchronized long lobBytePos(long aLobLocator, long aCharPos) throws SQLException {
        long result = 0L;
        this.begin((byte)67);
        this.cbw.putLong(aLobLocator);
        this.cbw.putInt((int)aCharPos);
        this.flush();
        if (this.check((byte)68)) {
            ex.test(this.cbr.longValue() != aLobLocator, (short)28);
            result = this.cbr.intValue() >> 0;
        }
        return result;
    }

    final synchronized boolean lobTruncate(long aLobLocator, long aLobLength, long aNewLength) throws SQLException {
        if (aNewLength < aLobLength) {
            this.begin((byte)51);
            this.cbw.putLong(aLobLocator);
            this.cbw.putInt(aNewLength);
            this.cbw.putInt(aLobLength - aNewLength);
            this.cbw.putInt(0);
            this.next((byte)54);
            this.cbw.putLong(aLobLocator);
            this.flush();
            return this.check((byte)55);
        }
        return false;
    }

    synchronized void meta(ABResultSet rs) throws SQLException {
        this.begin((byte)16);
        this.cbw.putInt(rs.getStatementID());
        this.cbw.putShort(rs.getResultSetID());
        this.cbw.putShort((short)0);
        this.flush();
        this.result(rs);
    }

    final cmb next() throws SQLException {
        if (this.cbw.remaining() < 64) {
            this.cbw.flush();
            this.cbw = this.chn.send(this.cbw);
            this.cbw.next();
            this.cbw.op(this.cbw.op);
            if (this.any != 0) {
                this.cbw.putByte(this.any);
            }
        }
        return this.cbw;
    }

    final cmb next(byte op) throws SQLException {
        if (this.cbw.remaining() < 64) {
            this.cbw.flush();
            this.cbw = this.chn.send(this.cbw);
            this.cbw.next();
        }
        this.cbw.op(op);
        return this.cbw;
    }

    final byte op() throws SQLException {
        this.mCurOpCode = (byte)127;
        if (this.cbr.remaining() == 1) {
            this.mCurOpCode = this.cbr.get();
        }
        if (this.cbr.remaining() == 0) {
            if (this.cbr.isLast()) {
                return this.mCurOpCode;
            }
            this.cbr = this.chn.recv(this.cbr);
        }
        this.mCurOpCode = this.cbr.get();
        return this.mCurOpCode;
    }

    synchronized boolean writePrepareProtocol(ABPreparedStatement aStatement) throws SQLException {
        String sql = aStatement.mQueryString;
        int stmtId = aStatement.getID();
        while (true) {
            this.begin((byte)12);
            this.cbw.putInt(stmtId);
            this.put(sql);
            this.cbw.putByte((byte)0);
            try {
                this.flush();
            }
            catch (SQLException e) {
                this.reconnect();
                continue;
            }
            break;
        }
        this.result(aStatement);
        return aStatement.isSelect();
    }

    final void putBuffer(ByteBuffer aBuffer) throws SQLException {
        if (aBuffer.position() > 0) {
            this.putBufferDirectly(aBuffer);
        } else {
            this.putBufferWithSlice(aBuffer);
        }
    }

    private void putBufferWithSlice(ByteBuffer aBuffer) throws SQLException {
        ByteBuffer sSlice = aBuffer.slice();
        this.putBufferDirectly(sSlice);
        aBuffer.position(aBuffer.position() + sSlice.position());
    }

    private void putBufferDirectly(ByteBuffer aBuffer) throws SQLException {
        do {
            this.next();
        } while (this.cbw.put(aBuffer));
    }

    Object readProperty(short aPropertyId) throws SQLException {
        ex.test(aPropertyId != this.cbr.shortValue(), (short)23);
        switch (this.cbr.get()) {
            case 0: 
            case 1: {
                return null;
            }
            case 2: 
            case 3: {
                return this.cbr.getByte();
            }
            case 4: 
            case 5: {
                return this.cbr.getShort();
            }
            case 6: 
            case 7: {
                return this.cbr.getInteger();
            }
            case 8: 
            case 9: {
                return this.cbr.getLong();
            }
            case 10: {
                return this.cbr.getFloat();
            }
            case 11: {
                return this.cbr.getDouble();
            }
            case 12: {
                return this.cbr.getTimestamp(null);
            }
            case 15: {
                return this.getString();
            }
        }
        ex.exception((short)23);
        return null;
    }

    final cmb remain() throws SQLException {
        if (this.cbr.remaining() == 0) {
            if (this.cbr.isLast()) {
                this.any = 0;
            } else {
                this.cbr = this.chn.recv(this.cbr);
                if (this.any != 1) {
                    byte sNewOpCode = this.cbr.get();
                    ex.test(sNewOpCode != this.mCurOpCode, (short)29, SQLStates.mBugmsg[2]);
                    this.mCurOpCode = sNewOpCode;
                    if (this.any != 0) {
                        this.cbr.get();
                    }
                }
            }
        }
        return this.cbr;
    }

    final cmb setAny(byte any) throws SQLException {
        this.any = any;
        this.cbw.putByte(any);
        return this.cbw;
    }

    void setProperty(byte aPropertyId, byte aProperty) throws SQLException {
        this.begin();
        this.appendProperty(aPropertyId, aProperty);
        this.flush();
        this.check((byte)11);
    }

    void setProperty(byte aPropertyId, int aProperty) throws SQLException {
        this.begin();
        this.appendProperty(aPropertyId, aProperty);
        this.flush();
        this.check((byte)11);
    }

    void setProperty(byte aPropertyId, long aProperty) throws SQLException {
        this.begin();
        this.appendProperty(aPropertyId, aProperty);
        this.flush();
        this.check((byte)11);
    }

    void setProperty(byte aPropertyId, String aProperty) throws SQLException {
        this.begin();
        this.appendProperty(aPropertyId, aProperty);
        this.flush();
        this.check((byte)11);
    }

    void setProperty(int stmtId, byte aPropertiyId, int aProperty) throws SQLException {
        this.setProperty(aPropertiyId, aProperty);
    }

    int timeout() throws SQLException {
        return this.chn.timeout;
    }

    synchronized void transaction(byte op) throws SQLException {
        this.begin((byte)45);
        this.cbw.putByte(op);
        this.flush();
        this.check((byte)46);
    }

    final void xa_conn(Xid xid, byte func, int rmid, long flags, long arg) throws SQLException {
        this.next((byte)60);
        this.cbw.putByte(func);
        this.cbw.putInt(rmid);
        this.cbw.putLong(flags);
        this.cbw.putLong(arg);
    }

    final void xa_transaction(XID xid, byte func, int rmid, long flags, long arg) throws SQLException, XAException {
        if (xid.getgLength() > 64L || xid.getbLength() > 64L) {
            throw new XAException(-4);
        }
        byte[] sBqualData = xid.getBranchQualifier();
        byte[] sGtridData = xid.getGlobalTransactionId();
        ByteBuffer sXidData = this.getTmpBuffer(128);
        this.next((byte)63);
        this.cbw.putByte(func);
        this.cbw.putInt(rmid);
        this.cbw.putLong(flags);
        this.cbw.putLong(arg);
        this.cbw.putLong(xid.getFormatId());
        this.cbw.putLong(xid.getgLength());
        this.cbw.putLong(xid.getbLength());
        int i = 0;
        while ((long)i < xid.getgLength()) {
            sXidData.put(sGtridData[i]);
            ++i;
        }
        i = 0;
        while ((long)i < xid.getbLength()) {
            sXidData.put(sBqualData[i]);
            ++i;
        }
        for (i = (int)(xid.getgLength() + xid.getbLength()); i < 128; ++i) {
            sXidData.put((byte)0);
        }
        sXidData.flip();
        this.putBuffer(sXidData);
    }

    final int xa_exec_result(byte func) throws SQLException {
        SQLException e = null;
        int rc = 0;
        byte fc = 2;
        this.flush();
        do {
            switch (this.op()) {
                case 46: {
                    break;
                }
                case 44: {
                    break;
                }
                case 1: {
                    e = this.error(e);
                    break;
                }
                case 62: {
                    fc = this.cbr.get();
                    rc = this.cbr.intValue();
                    break;
                }
                default: {
                    ex.exception((short)23);
                }
            }
        } while (fc != func);
        if (e != null) {
            throw e;
        }
        return rc;
    }

    final XID readXid() throws XAException {
        XID xid = null;
        try {
            byte op = this.op();
            long sFormatId = this.cbr.longValue();
            long sGLength = this.cbr.longValue();
            long sBLength = this.cbr.longValue();
            if (sGLength > 64L || sBLength > 64L) {
                throw new XAException(-4);
            }
            ByteBuffer xaData = this.getTmpBuffer(128);
            this.get(xaData);
            byte[] sGtridData = new byte[(int)sGLength];
            byte[] sBqualData = new byte[(int)sBLength];
            xaData.get(sGtridData);
            xaData.get(sBqualData);
            xid = new XID(sFormatId, sGtridData, sBqualData, sBLength, sGLength);
        }
        catch (SQLException se) {
            throw new ABXAException(-3);
        }
        return xid;
    }

    final synchronized int xa_exec_conn(Xid xid, byte func, int rmid, long flags, long arg) throws SQLException {
        this.begin();
        this.xa_conn(xid, func, rmid, flags, arg);
        return this.xa_exec_result(func);
    }

    final synchronized int xa_trans(Xid xid, byte func, int rmid, long flags, long arg) throws SQLException, XAException {
        this.begin();
        this.xa_transaction((XID)xid, func, rmid, flags, arg);
        return this.xa_exec_result(func);
    }

    static cmp connect(String host, int port) throws SQLException {
        cmnTCP channel = new cmnTCP(host, port);
        cmp protocol = new cmp(channel);
        return protocol;
    }

    synchronized void reconnect() throws SQLException {
        this.chn.disconnect();
        this.connect(this.sDBN, this.sCharset, this.sUID, this.sPWD, this.sTimeout);
    }
}

