/*
 * Decompiled with CFR 0.152.
 */
package Altibase.jdbc.driver;

import Altibase.jdbc.driver.ABSerialize;
import Altibase.jdbc.driver.SQLStates;
import Altibase.jdbc.driver.cmb;
import Altibase.jdbc.driver.cmp;
import Altibase.jdbc.driver.ex;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;

public class mtdNumeric
extends Number
implements Comparable,
ABSerialize,
SQLStates {
    static final long serialVersionUID = 1L;
    static final byte BYTE_PRECISION = 2;
    static final byte SHORT_PRECISION = 4;
    static final byte INT_PRECISION = 9;
    static final byte LONG_PRECISION = 18;
    static final byte REAL_PRECISION = 7;
    static final byte DOUBLE_PRECISION = 15;
    static final byte PRECISION_MIN = 0;
    static final byte PRECISION_MAX = 38;
    byte precision;
    short scale;
    byte size;
    byte sign;
    byte[] mag;

    mtdNumeric(int aPrecision) throws SQLException {
        this.setPrecision(aPrecision);
        this.scale = 0;
        this.size = (byte)-1;
    }

    final void setPrecision(int aPrecision) throws SQLException {
        ex.test(aPrecision > 38 && aPrecision > 0, (short)37);
        this.precision = (byte)aPrecision;
    }

    public int compareTo(Object aO) {
        return 0;
    }

    public double doubleValue() {
        BigDecimal bd = this.getBigDecimal();
        if (bd != null) {
            return bd.doubleValue();
        }
        return 0.0;
    }

    public float floatValue() {
        BigDecimal bd = this.getBigDecimal();
        if (bd != null) {
            return bd.floatValue();
        }
        return 0.0f;
    }

    final BigDecimal getBigDecimal() {
        if (this.isNull()) {
            return null;
        }
        short bscale = this.scale;
        if (bscale > 0) {
            return new BigDecimal(this.getBigInteger(), bscale);
        }
        return new BigDecimal(this.getBigInteger()).movePointRight(-bscale);
    }

    final BigInteger getBigInteger() {
        if (this.isNull()) {
            return null;
        }
        int bsign = this.sign == 1 ? 1 : -1;
        return new BigInteger(bsign, this.mag);
    }

    public int intValue() {
        BigDecimal bd = this.getBigDecimal();
        if (bd != null) {
            return bd.intValue();
        }
        return 0;
    }

    final boolean isNull() {
        return this.size < 0 || this.mag == null;
    }

    public long longValue() {
        BigDecimal bd = this.getBigDecimal();
        if (bd != null) {
            return bd.longValue();
        }
        return 0L;
    }

    public void read(cmp chn) throws SQLException {
        cmb bb = chn.remain();
        this.size = bb.get();
        this.precision = bb.get();
        this.scale = bb.shortValue();
        this.sign = bb.get();
        this.mag = new byte[this.size];
        bb.getBytes(this.mag, 0, this.size);
    }

    static final byte[] swap(byte[] b, byte z) {
        byte[] v = new byte[z];
        for (byte i = 0; i <= (z = (byte)(z - 1)); i = (byte)(i + 1)) {
            v[z] = b[i];
            v[i] = b[z];
        }
        return v;
    }

    final void set(BigDecimal aBigDecimal) throws SQLException {
        this.set(aBigDecimal.unscaledValue(), aBigDecimal.scale());
    }

    final void set(BigInteger aBigInteger, int aScale) throws SQLException {
        if (aBigInteger.signum() > 0) {
            this.sign = 1;
        } else {
            this.sign = 0;
            aBigInteger = aBigInteger.negate();
        }
        this.mag = aBigInteger.toByteArray();
        ex.test(this.mag.length > 16, (short)37);
        this.precision = (byte)38;
        this.size = (byte)(this.mag.length & 0xFF);
        this.scale = (short)(aScale & 0xFFFF);
    }

    final void set(byte v) {
        this.set((int)v);
    }

    final void set(double v) throws SQLException {
        this.set(new BigDecimal(v));
    }

    final void set(float v) throws SQLException {
        this.set((double)v);
    }

    final void set(int v) {
        this.sign = 0;
        if (v < 0) {
            v = -v;
            this.sign = 1;
        }
        this.mag[0] = (byte)(v >>>= 0);
        this.mag[1] = (byte)(v >>>= 8);
        this.mag[2] = (byte)(v >>>= 8);
        this.mag[3] = (byte)(v >>>= 8);
        this.size = (byte)4;
        this.scale = 0;
        this.precision = (byte)10;
    }

    final void set(long v) {
        this.sign = 0;
        if (v < 0L) {
            v = -v;
            this.sign = 1;
        }
        this.mag[0] = (byte)(v >>>= 0);
        this.mag[1] = (byte)(v >>>= 8);
        this.mag[2] = (byte)(v >>>= 8);
        this.mag[3] = (byte)(v >>>= 8);
        this.mag[4] = (byte)(v >>>= 8);
        this.mag[5] = (byte)(v >>>= 8);
        this.mag[6] = (byte)(v >>>= 8);
        this.mag[7] = (byte)(v >>>= 8);
        this.size = (byte)8;
        this.scale = 0;
        this.precision = (byte)19;
    }

    final void set(short v) {
        this.set((int)v);
    }

    final void setNull() {
        this.size = (byte)-1;
    }

    final Object getObject() {
        if (this.isNull()) {
            return null;
        }
        if (this.scale == 0) {
            return this.getBigInteger();
        }
        return this.getBigDecimal();
    }

    public String toString() {
        return this.getObject().toString();
    }

    public void write(cmp chn) throws SQLException {
        cmb cbw = chn.next();
        if (this.isNull()) {
            cbw.putByte((byte)1);
        } else {
            cbw.putByte((byte)14);
            cbw.putByte(this.size);
            cbw.putByte(this.precision);
            cbw.putShort(this.scale);
            cbw.putByte(this.sign);
            cbw.putBytes(this.mag, 0, this.size);
        }
    }
}

