/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.fdl.cmmn.aspect;

import egovframework.rte.fdl.cmmn.exception.BaseException;
import egovframework.rte.fdl.cmmn.exception.EgovBizException;
import egovframework.rte.fdl.cmmn.exception.FdlException;
import egovframework.rte.fdl.cmmn.exception.manager.ExceptionHandlerService;
import java.util.Locale;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.dao.DataAccessException;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;

public class ExceptionTransfer {
    protected Log log = LogFactory.getLog(this.getClass());
    @Resource(name="messageSource")
    private MessageSource messageSource;
    private ExceptionHandlerService[] exceptionHandlerServices;
    private PathMatcher pm = new AntPathMatcher();

    public void setExceptionHandlerService(ExceptionHandlerService[] exceptionHandlerServices) {
        this.exceptionHandlerServices = exceptionHandlerServices;
        if (this.exceptionHandlerServices != null) {
            this.log.debug((Object)(" count of ExceptionHandlerServices = " + exceptionHandlerServices.length));
        }
    }

    public int countOfTheExceptionHandlerService() {
        return this.exceptionHandlerServices != null ? this.exceptionHandlerServices.length : 0;
    }

    public void transfer(JoinPoint thisJoinPoint, Exception exception) throws Exception {
        this.log.debug((Object)"execute ExceptionTransfer.transfer ");
        Class<?> clazz = thisJoinPoint.getTarget().getClass();
        Signature signature = thisJoinPoint.getSignature();
        Locale locale = LocaleContextHolder.getLocale();
        if (exception instanceof EgovBizException) {
            this.log.debug((Object)"Exception case :: EgovBizException ");
            EgovBizException be = (EgovBizException)exception;
            this.getLog(clazz).error((Object)be.getMessage(), be.getCause());
            this.processHandling(clazz, signature.getName(), exception, this.pm, this.exceptionHandlerServices);
            throw be;
        }
        if (exception instanceof RuntimeException) {
            this.log.debug((Object)"RuntimeException case :: RuntimeException ");
            RuntimeException be = (RuntimeException)exception;
            this.getLog(clazz).error((Object)be.getMessage(), be.getCause());
            this.processHandling(clazz, signature.getName(), exception, this.pm, this.exceptionHandlerServices);
            if (be instanceof DataAccessException) {
                this.log.debug((Object)"RuntimeException case :: DataAccessException ");
                DataAccessException sqlEx = (DataAccessException)be;
                throw sqlEx;
            }
            throw be;
        }
        if (exception instanceof FdlException) {
            this.log.debug((Object)"FdlException case :: FdlException ");
            FdlException fe = (FdlException)exception;
            this.getLog(clazz).error((Object)fe.getMessage(), fe.getCause());
            throw fe;
        }
        this.log.debug((Object)"case :: Exception ");
        this.getLog(clazz).error((Object)exception.getMessage(), exception.getCause());
        throw this.processException(clazz, "fail.common.msg", new String[0], exception, locale);
    }

    protected Exception processException(Class clazz, String msgKey, String[] msgArgs, Exception e, Locale locale) {
        return this.processException(clazz, msgKey, msgArgs, e, locale, null);
    }

    protected Exception processException(Class clazz, final String msgKey, final String[] msgArgs, final Exception e, final Locale locale, ExceptionCreator exceptionCreator) {
        this.getLog(clazz).error((Object)this.messageSource.getMessage(msgKey, (Object[])msgArgs, locale), (Throwable)e);
        ExceptionCreator eC = null;
        if (exceptionCreator == null) {
            eC = new ExceptionCreator(){

                public Exception processException(MessageSource messageSource) {
                    return new BaseException(messageSource, msgKey, (Object[])msgArgs, locale, (Throwable)e);
                }
            };
        }
        return eC.processException(this.messageSource);
    }

    protected Log getLog(Class clazz) {
        return LogFactory.getLog((Class)clazz);
    }

    protected void processHandling(Class clazz, String methodName, Exception exception, PathMatcher pm, ExceptionHandlerService[] exceptionHandlerServices) {
        try {
            ExceptionHandlerService[] exceptionHandlerServiceArray = exceptionHandlerServices;
            int n = exceptionHandlerServices.length;
            int n2 = 0;
            while (n2 < n) {
                ExceptionHandlerService ehm = exceptionHandlerServiceArray[n2];
                if (!ehm.hasReqExpMatcher()) {
                    ehm.setReqExpMatcher(pm);
                }
                System.out.println(String.valueOf(clazz.getCanonicalName()) + "." + methodName);
                ehm.setPackageName(String.valueOf(clazz.getCanonicalName()) + "." + methodName);
                ehm.run(exception);
                ++n2;
            }
        }
        catch (Exception e) {
            this.getLog(clazz).error((Object)e.getMessage(), e.getCause());
        }
    }

    protected static interface ExceptionCreator {
        public Exception processException(MessageSource var1);
    }
}

