/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.emma;

import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.mojo.emma.EmmaUtils;
import org.codehaus.mojo.emma.task.ReportTask;

public class EmmaReportMojo
extends AbstractMavenReport {
    private static final String BUNDLE_BASENAME = EmmaReportMojo.class.getPackage().getName() + ".Resources";
    protected File outputDirectory;
    protected File[] sourcePaths;
    protected File metadataFile;
    protected File[] dataFiles;
    protected String outputEncoding;
    protected String depth;
    protected String columns;
    protected String sort;
    protected String metrics;
    protected boolean verbose;
    protected MavenProject project;
    protected List pluginClasspath;
    protected Renderer siteRenderer;
    private final Map bundles = new WeakHashMap();

    protected void checkParameters() throws MavenReportException {
        if (this.getLog().isDebugEnabled()) {
            this.verbose = true;
        }
        if (this.dataFiles == null) {
            this.dataFiles = new File[]{new File(this.project.getBasedir(), "coverage.ec")};
        }
        if (this.sourcePaths == null) {
            this.sourcePaths = new File[]{new File(this.project.getBuild().getSourceDirectory())};
        }
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        this.checkParameters();
        if (!this.canGenerateReport()) {
            return;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Output directory: " + this.outputDirectory.getAbsolutePath()));
            this.getLog().debug((CharSequence)"Source paths:");
            for (int i = 0; i < this.sourcePaths.length; ++i) {
                this.getLog().debug((CharSequence)(" o " + this.sourcePaths[i]));
            }
        }
        File[] newDataFiles = EmmaUtils.fixDataFileLocations(this.project, this.dataFiles);
        ReportTask task = new ReportTask();
        task.setVerbose(this.verbose);
        task.setMetadataFile(this.metadataFile);
        task.setDataFiles(newDataFiles);
        task.setSourcePaths(this.sourcePaths);
        task.setOutputDirectory(this.outputDirectory);
        task.setColumns(this.columns);
        task.setDepth(this.depth);
        task.setEncoding(this.outputEncoding != null ? this.outputEncoding : "UTF-8");
        task.setMetrics(this.metrics);
        task.setSort(this.sort);
        try {
            task.execute();
        }
        catch (MojoExecutionException e) {
            throw new MavenReportException("Failed to generate EMMA report", (Exception)((Object)e));
        }
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.getAbsolutePath();
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    public String getDescription(Locale locale) {
        return this.getResourceBundle(locale).getString("emma.plugin.description");
    }

    public String getName(Locale locale) {
        return this.getResourceBundle(locale).getString("emma.plugin.name");
    }

    public String getOutputName() {
        return "emma/index";
    }

    public boolean isExternalReport() {
        return true;
    }

    public boolean canGenerateReport() {
        boolean ready = this.metadataFile.exists();
        if (!ready) {
            this.getLog().info((CharSequence)("Not generating EMMA report as the metadata file (" + this.metadataFile.getName() + ") could not be found"));
        }
        return ready;
    }

    protected ResourceBundle getResourceBundle(Locale locale) {
        ResourceBundle bundle = (ResourceBundle)this.bundles.get(locale);
        if (bundle == null) {
            bundle = ResourceBundle.getBundle(BUNDLE_BASENAME, locale);
            this.bundles.put(locale, bundle);
        }
        return bundle;
    }
}

