/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.emma.task;

import com.vladium.emma.report.ReportProcessor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.emma.task.AbstractTask;

public class ReportTask
extends AbstractTask {
    private static final Map TYPE_REPORT_FILES = new HashMap(2);
    private File[] sourcePaths = new File[0];
    private String encoding;
    private String depth;
    private String columns;
    private String sort;
    private String metrics;
    private File metadataFile;
    private File[] dataFiles = new File[0];
    private boolean generateOnlyXml;

    public void execute() throws MojoExecutionException {
        try {
            String[] data;
            ReportProcessor processor = ReportProcessor.create();
            ArrayList<String> paths = new ArrayList<String>(2);
            if (this.metadataFile != null) {
                paths.add(this.metadataFile.getCanonicalPath());
            }
            if ((data = this.getCanonicalPaths(this.dataFiles)) != null) {
                paths.addAll(Arrays.asList(data));
            }
            processor.setDataPath(paths.toArray(new String[paths.size()]));
            String[] sources = this.getCanonicalPaths(this.sourcePaths);
            if (sources != null) {
                processor.setSourcePath(sources);
            }
            ArrayList<String> types = new ArrayList<String>(2);
            types.add("xml");
            if (!this.generateOnlyXml) {
                types.add("html");
            }
            Properties props = new Properties();
            Iterator iterator = types.iterator();
            while (iterator.hasNext()) {
                String type = (String)iterator.next();
                String prefix = "report." + type + ".";
                File outputFile = new File(this.getOutputDirectory(), (String)TYPE_REPORT_FILES.get(type));
                props.setProperty(prefix + "out.file", outputFile.getCanonicalPath());
                if (this.columns != null) {
                    props.setProperty(prefix + "columns", this.columns);
                }
                if (this.sort != null) {
                    props.setProperty(prefix + "sort", this.sort);
                }
                if (this.metrics != null) {
                    props.setProperty(prefix + "metrics", this.metrics);
                }
                if (this.depth != null) {
                    props.setProperty(prefix + "depth", this.depth);
                }
                if (this.encoding == null) continue;
                props.setProperty(prefix + "out.encoding", this.encoding);
            }
            if (this.isVerbose()) {
                props.setProperty("verbosity.level", "verbose");
            }
            processor.setReportTypes(types.toArray(new String[types.size()]));
            processor.setPropertyOverrides(props);
            processor.run();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to execute EMMA", (Exception)e);
        }
    }

    public String getColumns() {
        return this.columns;
    }

    public void setColumns(String columns) {
        this.columns = columns;
    }

    public String getDepth() {
        return this.depth;
    }

    public void setDepth(String depth) {
        this.depth = depth;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getMetrics() {
        return this.metrics;
    }

    public void setMetrics(String metrics) {
        this.metrics = metrics;
    }

    public String getSort() {
        return this.sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public File[] getSourcePaths() {
        return this.sourcePaths;
    }

    public void setSourcePaths(File[] sourcePaths) {
        this.sourcePaths = sourcePaths;
    }

    public File[] getDataFiles() {
        return this.dataFiles;
    }

    public void setDataFiles(File[] dataFiles) {
        this.dataFiles = dataFiles;
    }

    public File getMetadataFile() {
        return this.metadataFile;
    }

    public void setMetadataFile(File metadataFile) {
        this.metadataFile = metadataFile;
    }

    public boolean isGenerateOnlyXml() {
        return this.generateOnlyXml;
    }

    public void setGenerateOnlyXml(boolean generateOnlyXml) {
        this.generateOnlyXml = generateOnlyXml;
    }

    static {
        TYPE_REPORT_FILES.put("xml", "coverage.xml");
        TYPE_REPORT_FILES.put("html", "index.html");
    }
}

