/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.jasperreports;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRExporter;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import org.springframework.ui.jasperreports.JasperReportsUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.view.jasperreports.AbstractJasperReportsView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJasperReportsSingleFormatView
extends AbstractJasperReportsView {
    @Override
    protected boolean generatesDownloadContent() {
        return !this.useWriter();
    }

    @Override
    protected void renderReport(JasperPrint populatedReport, Map<String, Object> model, HttpServletResponse response) throws Exception {
        JRExporter exporter = this.createExporter();
        Map<JRExporterParameter, Object> mergedExporterParameters = this.getConvertedExporterParameters();
        if (!CollectionUtils.isEmpty(mergedExporterParameters)) {
            exporter.setParameters(mergedExporterParameters);
        }
        if (this.useWriter()) {
            this.renderReportUsingWriter(exporter, populatedReport, response);
        } else {
            this.renderReportUsingOutputStream(exporter, populatedReport, response);
        }
    }

    protected void renderReportUsingWriter(JRExporter exporter, JasperPrint populatedReport, HttpServletResponse response) throws Exception {
        String contentType = this.getContentType();
        String encoding = (String)exporter.getParameter(JRExporterParameter.CHARACTER_ENCODING);
        if (encoding != null && contentType != null && !contentType.toLowerCase().contains(";charset=")) {
            contentType = String.valueOf(contentType) + ";charset=" + encoding;
        }
        response.setContentType(contentType);
        JasperReportsUtils.render((JRExporter)exporter, (JasperPrint)populatedReport, (Writer)response.getWriter());
    }

    protected void renderReportUsingOutputStream(JRExporter exporter, JasperPrint populatedReport, HttpServletResponse response) throws Exception {
        ByteArrayOutputStream baos = this.createTemporaryOutputStream();
        JasperReportsUtils.render((JRExporter)exporter, (JasperPrint)populatedReport, (OutputStream)baos);
        this.writeToResponse(response, baos);
    }

    protected abstract JRExporter createExporter();

    protected abstract boolean useWriter();
}

