/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapping.result.loader;

import com.ibatis.sqlmap.engine.impl.SqlMapClientImpl;
import com.ibatis.sqlmap.engine.mapping.result.loader.EnhancedLazyResultLoader;
import com.ibatis.sqlmap.engine.mapping.result.loader.LazyResultLoader;
import com.ibatis.sqlmap.engine.type.DomCollectionTypeMarker;
import java.lang.reflect.Array;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ResultLoader {
    private ResultLoader() {
    }

    public static Object loadResult(SqlMapClientImpl client, String statementName, Object parameterObject, Class targetType) throws SQLException {
        Object value = null;
        if (client.isLazyLoadingEnabled()) {
            if (client.isEnhancementEnabled()) {
                EnhancedLazyResultLoader lazy = new EnhancedLazyResultLoader(client, statementName, parameterObject, targetType);
                value = lazy.loadResult();
            } else {
                LazyResultLoader lazy = new LazyResultLoader(client, statementName, parameterObject, targetType);
                value = lazy.loadResult();
            }
        } else {
            value = ResultLoader.getResult(client, statementName, parameterObject, targetType);
        }
        return value;
    }

    protected static Object getResult(SqlMapClientImpl client, String statementName, Object parameterObject, Class targetType) throws SQLException {
        Object value = null;
        if (DomCollectionTypeMarker.class.isAssignableFrom(targetType)) {
            value = client.queryForList(statementName, parameterObject);
        } else if (Set.class.isAssignableFrom(targetType)) {
            value = new HashSet(client.queryForList(statementName, parameterObject));
        } else if (Collection.class.isAssignableFrom(targetType)) {
            value = client.queryForList(statementName, parameterObject);
        } else if (targetType.isArray()) {
            List list = client.queryForList(statementName, parameterObject);
            value = ResultLoader.listToArray(list, targetType.getComponentType());
        } else {
            value = client.queryForObject(statementName, parameterObject);
        }
        return value;
    }

    private static Object listToArray(List list, Class type) {
        Object[] array = Array.newInstance(type, list.size());
        if (type.isPrimitive()) {
            Iterator iter = list.iterator();
            int index = 0;
            while (iter.hasNext()) {
                Array.set(array, index++, iter.next());
            }
        } else {
            array = list.toArray((Object[])array);
        }
        return array;
    }
}

