/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.bean;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.springmodules.validation.bean.rule.DefaultValidationRule;
import org.springmodules.validation.bean.rule.PropertyValidationRule;
import org.springmodules.validation.bean.rule.ValidationRule;
import org.springmodules.validation.util.condition.Condition;

public class RuleBasedValidator
implements Validator {
    private List globalRules = new ArrayList();
    private Map rulesByProperty = new HashMap();

    public boolean supports(Class clazz) {
        return true;
    }

    public void validate(Object obj, Errors errors) {
        Iterator iter = this.globalRules.iterator();
        while (iter.hasNext()) {
            ValidationRule rule = (ValidationRule)iter.next();
            if (!rule.isApplicable(obj) || rule.getCondition().check(obj)) continue;
            errors.reject(rule.getErrorCode(), rule.getErrorArguments(obj), rule.getDefaultErrorMessage());
        }
        Iterator names = this.rulesByProperty.keySet().iterator();
        while (names.hasNext()) {
            String propertyName = (String)names.next();
            List rules = (List)this.rulesByProperty.get(propertyName);
            Iterator iter2 = rules.iterator();
            while (iter2.hasNext()) {
                ValidationRule rule = (ValidationRule)iter2.next();
                if (!rule.isApplicable(obj) || rule.getCondition().check(obj)) continue;
                errors.rejectValue(propertyName, rule.getErrorCode(), rule.getErrorArguments(obj), rule.getDefaultErrorMessage());
            }
        }
    }

    public void setExtraGlobalVadlidationRules(ValidationRule[] globalRules) {
        for (int i = 0; i < globalRules.length; ++i) {
            this.addGlobalRule(globalRules[i]);
        }
    }

    public void setExtraPropertyValidationRules(Map rulesByProperty) {
        Iterator entries = rulesByProperty.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            this.addPropertyRule((String)entry.getKey(), (ValidationRule)entry.getValue());
        }
    }

    public void addPropertyRule(String propertyName, Condition fieldValueCondition, String errorCode) {
        this.addPropertyRule(propertyName, fieldValueCondition, errorCode, errorCode, new Object[0]);
    }

    public void addPropertyRule(String propertyName, Condition fieldValueCondition, String errorCode, Object[] args) {
        this.addPropertyRule(propertyName, fieldValueCondition, errorCode, errorCode, args);
    }

    public void addPropertyRule(String propertyName, Condition fieldValueCondition, String errorCode, String message, Object[] args) {
        this.addPropertyRule(propertyName, new DefaultValidationRule(fieldValueCondition, errorCode, message, args));
    }

    public void addPropertyRule(String propertyName, ValidationRule propertyRule) {
        this.addPropertyGlobalRule(propertyName, new PropertyValidationRule(propertyName, propertyRule));
    }

    public void addPropertyGlobalRule(String propertyName, ValidationRule globalRule) {
        ArrayList<ValidationRule> rules = (ArrayList<ValidationRule>)this.rulesByProperty.get(propertyName);
        if (rules == null) {
            rules = new ArrayList<ValidationRule>();
            this.rulesByProperty.put(propertyName, rules);
        }
        rules.add(globalRule);
    }

    public void addGlobalRule(Condition condition, String errorCode) {
        this.addGlobalRule(condition, errorCode, errorCode, new Object[0]);
    }

    public void addGlobalRule(Condition condition, String errorCode, Object[] args) {
        this.addGlobalRule(condition, errorCode, errorCode, args);
    }

    public void addGlobalRule(Condition condition, String errorCode, String message, Object[] args) {
        this.addGlobalRule(new DefaultValidationRule(condition, errorCode, message, args));
    }

    public void addGlobalRule(Condition condition, String errorCode, String message) {
        this.addGlobalRule(new DefaultValidationRule(condition, errorCode, message, new Object[0]));
    }

    public void addGlobalRule(ValidationRule globalRule) {
        this.globalRules.add(globalRule);
    }
}

