/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.bean.context.web;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.PathMatcher;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springmodules.validation.bean.context.web.ValidationContextHandlerInterceptor;
import org.springmodules.validation.bean.context.web.ValidationContextUrlMapping;

public class ValidationContextFilter
extends OncePerRequestFilter {
    private ValidationContextHandlerInterceptor interceptor = new ValidationContextHandlerInterceptor();

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        try {
            if (this.interceptor.preHandle(request, response, null)) {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        }
        catch (Exception e) {
            throw new ServletException("Could not apply valication context filter", (Throwable)e);
        }
        finally {
            try {
                this.interceptor.postHandle(request, response, null, null);
            }
            catch (Exception e) {}
        }
    }

    public void setValidationContextUrlMappings(ValidationContextUrlMapping[] validationContextUrlMappings) {
        this.interceptor.setValidationContextUrlMappings(validationContextUrlMappings);
    }

    public ValidationContextUrlMapping[] getValidationContextUrlMappings() {
        return this.interceptor.getValidationContextUrlMappings();
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        this.interceptor.setPathMatcher(pathMatcher);
    }

    public PathMatcher getPathMatcher() {
        return this.interceptor.getPathMatcher();
    }
}

