/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rolling.helper;

import java.io.IOException;
import java.util.List;
import org.apache.log4j.ULogger;
import org.apache.log4j.rolling.helper.Action;
import org.apache.log4j.rolling.helper.ActionBase;

public class CompositeAction
extends ActionBase {
    private final Action[] actions;
    private final boolean stopOnError;
    private final ULogger logger;

    public CompositeAction(List actions, boolean stopOnError, ULogger logger) {
        this.actions = new Action[actions.size()];
        actions.toArray(this.actions);
        this.stopOnError = stopOnError;
        this.logger = logger;
    }

    public void run() {
        block2: {
            try {
                this.execute();
            }
            catch (IOException ex) {
                if (this.logger == null) break block2;
                this.logger.info((Object)"Exception during file rollover.", ex);
            }
        }
    }

    public boolean execute() throws IOException {
        if (this.stopOnError) {
            int i = 0;
            while (i < this.actions.length) {
                if (!this.actions[i].execute()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        boolean status = true;
        IOException exception = null;
        int i = 0;
        while (i < this.actions.length) {
            block7: {
                try {
                    status &= this.actions[i].execute();
                }
                catch (IOException ex) {
                    status = false;
                    if (exception != null) break block7;
                    exception = ex;
                }
            }
            ++i;
        }
        if (exception != null) {
            throw exception;
        }
        return status;
    }
}

