/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.dfa.report;

import java.util.Iterator;
import net.sourceforge.pmd.IRuleViolation;
import net.sourceforge.pmd.dfa.report.AbstractReportNode;
import net.sourceforge.pmd.dfa.report.ClassNode;
import net.sourceforge.pmd.dfa.report.PackageNode;
import net.sourceforge.pmd.dfa.report.ViolationNode;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportTree {
    private PackageNode rootNode = new PackageNode("");
    private AbstractReportNode level;

    public Iterator<IRuleViolation> iterator() {
        return new TreeIterator();
    }

    public int size() {
        int count = 0;
        Iterator<IRuleViolation> i = this.iterator();
        while (i.hasNext()) {
            i.next();
            ++count;
        }
        return count;
    }

    public AbstractReportNode getRootNode() {
        return this.rootNode;
    }

    public void addRuleViolation(IRuleViolation violation) {
        ViolationNode tmp;
        String pack = violation.getPackageName();
        String[] a = new String[]{};
        if (pack == null) {
            a = new String[]{""};
        } else if (pack.indexOf(46) != -1) {
            String[] tmp2 = pack.split("\\.");
            a = new String[tmp2.length];
            System.arraycopy(tmp2, 0, a, 0, tmp2.length);
        } else {
            a = new String[]{pack};
        }
        this.level = this.rootNode;
        String plugedPackageName = "";
        for (int i = 0; i < a.length; ++i) {
            String packageName = a[i];
            if (this.isStringInLevel(plugedPackageName = new StringBuffer().append(plugedPackageName).append(packageName).append('.').toString())) continue;
            PackageNode node = new PackageNode(plugedPackageName);
            this.level.addFirst(node);
            this.level = node;
        }
        String cl = violation.getClassName();
        if (!this.isStringInLevel(cl)) {
            ClassNode node = new ClassNode(cl);
            this.level.addFirst(node);
            this.level = node;
        }
        if (!this.equalsNodeInLevel(this.level, tmp = new ViolationNode(violation))) {
            this.level.add(tmp);
        }
    }

    private boolean equalsNodeInLevel(AbstractReportNode level, AbstractReportNode node) {
        for (int i = 0; i < level.getChildCount(); ++i) {
            if (!level.getChildAt(i).equalsNode(node)) continue;
            return true;
        }
        return false;
    }

    private boolean isStringInLevel(String str) {
        for (int i = 0; i < this.level.getChildCount(); ++i) {
            AbstractReportNode child = this.level.getChildAt(i);
            String tmp = null;
            if (child instanceof PackageNode) {
                tmp = ((PackageNode)child).getPackageName();
            }
            if (child instanceof ClassNode) {
                tmp = ((ClassNode)child).getClassName();
            }
            if (tmp == null) {
                return false;
            }
            if (!tmp.equals(str)) continue;
            this.level = child;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TreeIterator
    implements Iterator<IRuleViolation> {
        private AbstractReportNode iterNode;
        private boolean hasNextFlag;

        private TreeIterator() {
            this.iterNode = ReportTree.this.rootNode;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            this.hasNextFlag = true;
            return this.getNext() != null;
        }

        @Override
        public IRuleViolation next() {
            if (!this.hasNextFlag) {
                this.getNext();
            } else {
                this.hasNextFlag = false;
            }
            if (this.iterNode instanceof ViolationNode) {
                return ((ViolationNode)this.iterNode).getRuleViolation();
            }
            return null;
        }

        /*
         * Unable to fully structure code
         */
        private AbstractReportNode getNext() {
            do lbl-1000:
            // 3 sources

            {
                block3: {
                    if (!this.iterNode.isLeaf()) break block3;
                    while ((node = this.iterNode.getNextSibling()) == null) {
                        node = this.iterNode.getParent();
                        if (node == null) {
                            return null;
                        }
                        this.iterNode = node;
                    }
                    this.iterNode = node;
                    if (!this.iterNode.isLeaf()) ** GOTO lbl-1000
                    return this.iterNode;
                }
                this.iterNode = this.iterNode.getFirstChild();
            } while (!this.iterNode.isLeaf());
            return this.iterNode;
        }
    }
}

