/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.strings;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTAdditiveExpression;
import net.sourceforge.pmd.ast.ASTBlockStatement;
import net.sourceforge.pmd.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.ast.ASTFormalParameter;
import net.sourceforge.pmd.ast.ASTIfStatement;
import net.sourceforge.pmd.ast.ASTLiteral;
import net.sourceforge.pmd.ast.ASTMultiplicativeExpression;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.ast.ASTSwitchLabel;
import net.sourceforge.pmd.ast.ASTSwitchStatement;
import net.sourceforge.pmd.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.rules.strings.InefficientStringBuffering;
import net.sourceforge.pmd.symboltable.NameOccurrence;
import net.sourceforge.pmd.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.typeresolution.TypeHelper;
import net.sourceforge.retroweaver.runtime.java.lang.Integer_;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsufficientStringBufferDeclaration
extends AbstractRule {
    private static final Set<Class<? extends SimpleNode>> blockParents = new HashSet<Class<? extends SimpleNode>>();
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTIfStatement;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTName;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTPrimaryPrefix;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTBlockStatement;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTFormalParameter;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTPrimaryExpression;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTAdditiveExpression;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTFieldDeclaration;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTLiteral;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTMultiplicativeExpression;
    private static final /* synthetic */ Class class$java$lang$StringBuffer;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTSwitchStatement;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTSwitchLabel;

    @Override
    public Object visit(ASTVariableDeclaratorId node, Object data) {
        VariableNameDeclaration variableNameDeclaration = node.getNameDeclaration();
        Class<?> clazz = class$java$lang$StringBuffer;
        if (clazz == null) {
            clazz = class$java$lang$StringBuffer = new StringBuffer[0].getClass().getComponentType();
        }
        if (!TypeHelper.isA(variableNameDeclaration, (Class)clazz)) {
            return data;
        }
        SimpleNode rootNode = node;
        int anticipatedLength = 0;
        int constructorLength = 16;
        constructorLength = this.getConstructorLength(node, constructorLength);
        anticipatedLength = this.getInitialLength(node);
        List<NameOccurrence> usage = node.getUsages();
        HashMap<Node, Map<Node, Integer>> blocks = new HashMap<Node, Map<Node, Integer>>();
        for (int ix = 0; ix < usage.size(); ++ix) {
            Class<?> clazz2;
            NameOccurrence no = usage.get(ix);
            SimpleNode n = no.getLocation();
            if (!InefficientStringBuffering.isInStringBufferOperation(n, 3, "append")) {
                if (!no.isOnLeftHandSide() && !InefficientStringBuffering.isInStringBufferOperation(n, 3, "setLength")) continue;
                if (constructorLength != -1 && anticipatedLength > constructorLength) {
                    Object[] param = new String[]{String.valueOf(constructorLength), String.valueOf(anticipatedLength += this.processBlocks(blocks))};
                    this.addViolation(data, (Node)rootNode, param);
                }
                constructorLength = this.getConstructorLength(n, constructorLength);
                rootNode = n;
                anticipatedLength = this.getInitialLength(node);
            }
            if ((clazz2 = class$net$sourceforge$pmd$ast$ASTPrimaryExpression) == null) {
                clazz2 = new ASTPrimaryExpression[0].getClass().getComponentType();
            }
            ASTPrimaryExpression s = (ASTPrimaryExpression)n.getFirstParentOfType(clazz2);
            int numChildren = s.jjtGetNumChildren();
            for (int jx = 0; jx < numChildren; ++jx) {
                SimpleNode sn = (SimpleNode)s.jjtGetChild(jx);
                if (!(sn instanceof ASTPrimarySuffix) || sn.getImage() != null) continue;
                int thisSize = 0;
                Node block = this.getFirstParentBlock(sn);
                thisSize = this.isAdditive(sn) ? this.processAdditive(sn) : this.processNode(sn);
                if (block != null) {
                    this.storeBlockStatistics(blocks, thisSize, block);
                    continue;
                }
                anticipatedLength += thisSize;
            }
        }
        if (constructorLength != -1 && (anticipatedLength += this.processBlocks(blocks)) > constructorLength) {
            Object[] param = new String[]{String.valueOf(constructorLength), String.valueOf(anticipatedLength)};
            this.addViolation(data, (Node)rootNode, param);
        }
        return data;
    }

    private void storeBlockStatistics(Map<Node, Map<Node, Integer>> blocks, int thisSize, Node block) {
        Integer x;
        Map<Node, Integer> thisBranch;
        Node statement = block.jjtGetParent();
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTIfStatement;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTIfStatement = new ASTIfStatement[0].getClass().getComponentType();
        }
        if (clazz.equals(block.jjtGetParent().getClass())) {
            SimpleNode simpleNode = (SimpleNode)statement;
            Class<?> clazz2 = class$net$sourceforge$pmd$ast$ASTIfStatement;
            if (clazz2 == null) {
                clazz2 = class$net$sourceforge$pmd$ast$ASTIfStatement = new ASTIfStatement[0].getClass().getComponentType();
            }
            Node possibleStatement = (Node)simpleNode.getFirstParentOfType(clazz2);
            while (possibleStatement != null) {
                Class<?> clazz3 = possibleStatement.getClass();
                Class<?> clazz4 = class$net$sourceforge$pmd$ast$ASTIfStatement;
                if (clazz4 == null) {
                    clazz4 = new ASTIfStatement[0].getClass().getComponentType();
                }
                if (!clazz3.equals(clazz4)) break;
                statement = possibleStatement;
                SimpleNode simpleNode2 = (SimpleNode)possibleStatement;
                Class<?> clazz5 = class$net$sourceforge$pmd$ast$ASTIfStatement;
                if (clazz5 == null) {
                    clazz5 = new ASTIfStatement[0].getClass().getComponentType();
                }
                possibleStatement = (Node)simpleNode2.getFirstParentOfType(clazz5);
            }
        }
        if ((thisBranch = blocks.get(statement)) == null) {
            thisBranch = new HashMap<Node, Integer>();
            blocks.put(statement, thisBranch);
        }
        if ((x = thisBranch.get(block)) != null) {
            thisSize += x.intValue();
        }
        thisBranch.put(statement, Integer_.valueOf((int)thisSize));
    }

    private int processBlocks(Map<Node, Map<Node, Integer>> blocks) {
        int anticipatedLength = 0;
        int ifLength = 0;
        for (Map.Entry<Node, Map<Node, Integer>> entry : blocks.entrySet()) {
            ifLength = 0;
            for (Map.Entry<Node, Integer> entry2 : entry.getValue().entrySet()) {
                Integer value = entry2.getValue();
                ifLength = Math.max(ifLength, value);
            }
            anticipatedLength += ifLength;
        }
        return anticipatedLength;
    }

    private int processAdditive(SimpleNode sn) {
        ASTAdditiveExpression additive;
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTAdditiveExpression;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTAdditiveExpression = new ASTAdditiveExpression[0].getClass().getComponentType();
        }
        if ((additive = (ASTAdditiveExpression)sn.getFirstChildOfType(clazz)) == null) {
            return 0;
        }
        int anticipatedLength = 0;
        for (int ix = 0; ix < additive.jjtGetNumChildren(); ++ix) {
            ASTLiteral literal;
            SimpleNode childNode = (SimpleNode)additive.jjtGetChild(ix);
            Class<?> clazz2 = class$net$sourceforge$pmd$ast$ASTLiteral;
            if (clazz2 == null) {
                clazz2 = new ASTLiteral[0].getClass().getComponentType();
            }
            if ((literal = (ASTLiteral)childNode.getFirstChildOfType(clazz2)) == null || literal.getImage() == null) continue;
            anticipatedLength += literal.getImage().length() - 2;
        }
        return anticipatedLength;
    }

    private static final boolean isLiteral(String str) {
        if (str.length() == 0) {
            return false;
        }
        char c = str.charAt(0);
        return c == '\"' || c == '\'';
    }

    private int processNode(SimpleNode sn) {
        ASTPrimaryPrefix xn;
        int anticipatedLength = 0;
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTPrimaryPrefix;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTPrimaryPrefix = new ASTPrimaryPrefix[0].getClass().getComponentType();
        }
        if ((xn = (ASTPrimaryPrefix)sn.getFirstChildOfType(clazz)).jjtGetNumChildren() != 0) {
            String str;
            Class<?> clazz2 = xn.jjtGetChild(0).getClass();
            Class<?> clazz3 = class$net$sourceforge$pmd$ast$ASTLiteral;
            if (clazz3 == null) {
                clazz3 = class$net$sourceforge$pmd$ast$ASTLiteral = new ASTLiteral[0].getClass().getComponentType();
            }
            if (clazz2.equals(clazz3) && (str = ((SimpleNode)xn.jjtGetChild(0)).getImage()) != null) {
                anticipatedLength = InsufficientStringBufferDeclaration.isLiteral(str) ? (anticipatedLength += str.length() - 2) : (str.startsWith("0x") ? ++anticipatedLength : (anticipatedLength += str.length()));
            }
        }
        return anticipatedLength;
    }

    private int getConstructorLength(SimpleNode node, int constructorLength) {
        List literal;
        ASTMultiplicativeExpression mult;
        ASTAdditiveExpression exp;
        Class<?> clazz;
        SimpleNode block;
        int iConstructorLength = constructorLength;
        Class<?> clazz2 = class$net$sourceforge$pmd$ast$ASTBlockStatement;
        if (clazz2 == null) {
            clazz2 = class$net$sourceforge$pmd$ast$ASTBlockStatement = new ASTBlockStatement[0].getClass().getComponentType();
        }
        if ((block = (SimpleNode)node.getFirstParentOfType(clazz2)) == null) {
            Class<?> clazz3 = class$net$sourceforge$pmd$ast$ASTFieldDeclaration;
            if (clazz3 == null) {
                clazz3 = class$net$sourceforge$pmd$ast$ASTFieldDeclaration = new ASTFieldDeclaration[0].getClass().getComponentType();
            }
            block = (SimpleNode)node.getFirstParentOfType(clazz3);
        }
        if (block == null) {
            Class<?> clazz4 = class$net$sourceforge$pmd$ast$ASTFormalParameter;
            if (clazz4 == null) {
                clazz4 = class$net$sourceforge$pmd$ast$ASTFormalParameter = new ASTFormalParameter[0].getClass().getComponentType();
            }
            if ((block = (SimpleNode)node.getFirstParentOfType(clazz4)) != null) {
                iConstructorLength = -1;
            }
        }
        if ((clazz = class$net$sourceforge$pmd$ast$ASTAdditiveExpression) == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTAdditiveExpression = new ASTAdditiveExpression[0].getClass().getComponentType();
        }
        if ((exp = (ASTAdditiveExpression)block.getFirstChildOfType(clazz)) != null) {
            return 16;
        }
        Class<?> clazz5 = class$net$sourceforge$pmd$ast$ASTMultiplicativeExpression;
        if (clazz5 == null) {
            clazz5 = class$net$sourceforge$pmd$ast$ASTMultiplicativeExpression = new ASTMultiplicativeExpression[0].getClass().getComponentType();
        }
        if ((mult = (ASTMultiplicativeExpression)block.getFirstChildOfType(clazz5)) != null) {
            return 16;
        }
        Class<?> clazz6 = class$net$sourceforge$pmd$ast$ASTLiteral;
        if (clazz6 == null) {
            clazz6 = class$net$sourceforge$pmd$ast$ASTLiteral = new ASTLiteral[0].getClass().getComponentType();
        }
        if ((literal = block.findChildrenOfType(clazz6)).isEmpty()) {
            List name;
            Class<?> clazz7 = class$net$sourceforge$pmd$ast$ASTName;
            if (clazz7 == null) {
                clazz7 = class$net$sourceforge$pmd$ast$ASTName = new ASTName[0].getClass().getComponentType();
            }
            if (!(name = block.findChildrenOfType(clazz7)).isEmpty()) {
                iConstructorLength = -1;
            }
        } else {
            String str;
            iConstructorLength = literal.size() == 1 ? ((str = ((ASTLiteral)literal.get(0)).getImage()) == null ? 0 : (InsufficientStringBufferDeclaration.isLiteral(str) ? 14 + str.length() : Integer.parseInt(str))) : -1;
        }
        if (iConstructorLength == 0) {
            iConstructorLength = 16;
        }
        return iConstructorLength;
    }

    private int getInitialLength(SimpleNode node) {
        String str;
        List literal;
        Class<?> clazz;
        SimpleNode block;
        Class<?> clazz2 = class$net$sourceforge$pmd$ast$ASTBlockStatement;
        if (clazz2 == null) {
            clazz2 = class$net$sourceforge$pmd$ast$ASTBlockStatement = new ASTBlockStatement[0].getClass().getComponentType();
        }
        if ((block = (SimpleNode)node.getFirstParentOfType(clazz2)) == null) {
            Class<?> clazz3 = class$net$sourceforge$pmd$ast$ASTFieldDeclaration;
            if (clazz3 == null) {
                clazz3 = class$net$sourceforge$pmd$ast$ASTFieldDeclaration = new ASTFieldDeclaration[0].getClass().getComponentType();
            }
            if ((block = (SimpleNode)node.getFirstParentOfType(clazz3)) == null) {
                Class<?> clazz4 = class$net$sourceforge$pmd$ast$ASTFormalParameter;
                if (clazz4 == null) {
                    clazz4 = class$net$sourceforge$pmd$ast$ASTFormalParameter = new ASTFormalParameter[0].getClass().getComponentType();
                }
                block = (SimpleNode)node.getFirstParentOfType(clazz4);
            }
        }
        if ((clazz = class$net$sourceforge$pmd$ast$ASTLiteral) == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTLiteral = new ASTLiteral[0].getClass().getComponentType();
        }
        if ((literal = block.findChildrenOfType(clazz)).size() == 1 && (str = ((ASTLiteral)literal.get(0)).getImage()) != null && InsufficientStringBufferDeclaration.isLiteral(str)) {
            return str.length() - 2;
        }
        return 0;
    }

    private boolean isAdditive(SimpleNode n) {
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTAdditiveExpression;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTAdditiveExpression = new ASTAdditiveExpression[0].getClass().getComponentType();
        }
        return n.findChildrenOfType(clazz).size() >= 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Node getFirstParentBlock(Node node) {
        Node parentNode;
        Node lastNode = node;
        for (parentNode = node.jjtGetParent(); parentNode != null && !blockParents.contains(parentNode.getClass()); parentNode = parentNode.jjtGetParent()) {
            lastNode = parentNode;
        }
        if (parentNode != null) {
            Class<?> clazz = class$net$sourceforge$pmd$ast$ASTIfStatement;
            if (clazz == null) {
                clazz = class$net$sourceforge$pmd$ast$ASTIfStatement = new ASTIfStatement[0].getClass().getComponentType();
            }
            if (clazz.equals(parentNode.getClass())) {
                return lastNode;
            }
        }
        if (parentNode == null) return parentNode;
        Class<?> clazz = parentNode.getClass();
        Class<?> clazz2 = class$net$sourceforge$pmd$ast$ASTSwitchStatement;
        if (clazz2 == null) {
            clazz2 = class$net$sourceforge$pmd$ast$ASTSwitchStatement = new ASTSwitchStatement[0].getClass().getComponentType();
        }
        if (!clazz.equals(clazz2)) return parentNode;
        return InsufficientStringBufferDeclaration.getSwitchParent(parentNode, lastNode);
    }

    private static Node getSwitchParent(Node parentNode, Node lastNode) {
        int allChildren = parentNode.jjtGetNumChildren();
        ASTSwitchLabel label = null;
        for (int ix = 0; ix < allChildren; ++ix) {
            Node n = parentNode.jjtGetChild(ix);
            Class<?> clazz = n.getClass();
            Class<?> clazz2 = class$net$sourceforge$pmd$ast$ASTSwitchLabel;
            if (clazz2 == null) {
                clazz2 = new ASTSwitchLabel[0].getClass().getComponentType();
            }
            if (clazz.equals(clazz2)) {
                label = (ASTSwitchLabel)n;
                continue;
            }
            if (!n.equals(lastNode)) continue;
            parentNode = label;
            break;
        }
        return parentNode;
    }

    static {
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTIfStatement;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTIfStatement = new ASTIfStatement[0].getClass().getComponentType();
        }
        blockParents.add((Class<? extends SimpleNode>)clazz);
        Class<?> clazz2 = class$net$sourceforge$pmd$ast$ASTSwitchStatement;
        if (clazz2 == null) {
            clazz2 = class$net$sourceforge$pmd$ast$ASTSwitchStatement = new ASTSwitchStatement[0].getClass().getComponentType();
        }
        blockParents.add((Class<? extends SimpleNode>)clazz2);
    }
}

