/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules;

import java.util.Map;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.ast.ASTPrimitiveType;
import net.sourceforge.pmd.ast.ASTReferenceType;
import net.sourceforge.pmd.ast.ASTType;
import net.sourceforge.pmd.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.properties.StringProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableNamingConventions
extends AbstractRule {
    private String[] staticPrefixes;
    private String[] staticSuffixes;
    private String[] memberPrefixes;
    private String[] memberSuffixes;
    private static final PropertyDescriptor staticPrefixesDescriptor = new StringProperty("staticPrefix", "Static prefixes", new String[]{""}, 1.0f, ',');
    private static final PropertyDescriptor staticSuffixesDescriptor = new StringProperty("staticSuffix", "Static suffixes", new String[]{""}, 2.0f, ',');
    private static final PropertyDescriptor memberPrefixesDescriptor = new StringProperty("memberPrefix", "Member prefixes", new String[]{""}, 3.0f, ',');
    private static final PropertyDescriptor memberSuffixesDescriptor = new StringProperty("memberSuffix", "Member suffixes", new String[]{""}, 4.0f, ',');
    private static final Map<String, PropertyDescriptor> propertyDescriptorsByName = VariableNamingConventions.asFixedMap(new PropertyDescriptor[]{staticPrefixesDescriptor, staticSuffixesDescriptor, memberPrefixesDescriptor, memberSuffixesDescriptor});

    @Override
    protected Map<String, PropertyDescriptor> propertiesByName() {
        return propertyDescriptorsByName;
    }

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        this.init();
        return super.visit(node, data);
    }

    protected void init() {
        this.staticPrefixes = this.getStringProperties(staticPrefixesDescriptor);
        this.staticSuffixes = this.getStringProperties(staticSuffixesDescriptor);
        this.memberPrefixes = this.getStringProperties(memberPrefixesDescriptor);
        this.memberSuffixes = this.getStringProperties(memberSuffixesDescriptor);
    }

    @Override
    public Object visit(ASTFieldDeclaration node, Object data) {
        return this.checkNames(node, data);
    }

    private Object checkNames(ASTFieldDeclaration node, Object data) {
        ASTType childNodeType = (ASTType)node.jjtGetChild(0);
        String varType = "";
        if (childNodeType.jjtGetChild(0) instanceof ASTReferenceType) {
            ASTReferenceType refType = (ASTReferenceType)childNodeType.jjtGetChild(0);
            varType = refType.jjtGetChild(0) instanceof ASTClassOrInterfaceType ? ((ASTClassOrInterfaceType)refType.jjtGetChild(0)).getImage() : "";
        } else if (childNodeType.jjtGetChild(0) instanceof ASTPrimitiveType) {
            varType = ((ASTPrimitiveType)childNodeType.jjtGetChild(0)).getImage();
        }
        if (varType != null && varType.length() > 0) {
            ASTVariableDeclarator childNodeName = (ASTVariableDeclarator)node.jjtGetChild(1);
            ASTVariableDeclaratorId childNodeId = (ASTVariableDeclaratorId)childNodeName.jjtGetChild(0);
            String varName = childNodeId.getImage();
            if (varName.equals("serialVersionUID") || node.isFinal() && !node.isStatic() && !node.isInterfaceMember()) {
                return data;
            }
            if (node.isStatic() && node.isFinal() || node.jjtGetParent().jjtGetParent().jjtGetParent() instanceof ASTClassOrInterfaceDeclaration && ((ASTClassOrInterfaceDeclaration)node.jjtGetParent().jjtGetParent().jjtGetParent()).isInterface()) {
                if (!varName.equals(varName.toUpperCase())) {
                    this.addViolationWithMessage(data, childNodeName, "final\uacfc static \ubcc0\uc218\ub294 \ubaa8\ub450 \ub300\ubb38\uc790\ub85c \uad6c\uc131\ub418\uc5b4\uc57c \ud568.");
                }
                return data;
            }
            String strippedVarName = null;
            strippedVarName = node.isStatic() ? this.normalizeStaticVariableName(varName) : this.normalizeMemberVariableName(varName);
            if (strippedVarName.indexOf(95) >= 0) {
                this.addViolationWithMessage(data, childNodeName, "final\uc774 \uc544\ub2cc \ubcc0\uc218\ub294 \ubc11\uc904\uc744 \ud3ec\ud568\ud574\uc11c\ub294 \uc548\ub428(\ud45c\uc900 \uc811\ub450\uc5b4/\uc811\ubbf8\uc5b4\uc640\uc758 \ubc11\uc904 \uc0ac\uc6a9\uc740 \uc608\uc678\ud568).");
            }
            if (Character.isUpperCase(varName.charAt(0))) {
                this.addViolationWithMessage(data, childNodeName, "\ubcc0\uc218\ub294 \uc18c\ubb38\uc790\ub85c \uc2dc\uc791\ud574\uc57c\ud568.");
            }
        }
        return data;
    }

    private String normalizeMemberVariableName(String varName) {
        return this.stripSuffix(this.stripPrefix(varName, this.memberPrefixes), this.memberSuffixes);
    }

    private String normalizeStaticVariableName(String varName) {
        return this.stripSuffix(this.stripPrefix(varName, this.staticPrefixes), this.staticSuffixes);
    }

    private String stripSuffix(String varName, String[] suffix) {
        if (suffix != null) {
            int i = 0;
            while (i < suffix.length) {
                if (varName.endsWith(suffix[i])) {
                    varName = varName.substring(0, varName.length() - suffix[i].length());
                    break;
                }
                ++i;
            }
        }
        return varName;
    }

    private String stripPrefix(String varName, String[] prefix) {
        if (prefix == null) {
            return varName;
        }
        int i = 0;
        while (i < prefix.length) {
            if (varName.startsWith(prefix[i])) {
                return varName.substring(prefix[i].length());
            }
            ++i;
        }
        return varName;
    }
}

