/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.design;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.ast.ASTAssignmentOperator;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.ast.ASTIfStatement;
import net.sourceforge.pmd.ast.ASTInitializer;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.ast.ASTStatementExpression;
import net.sourceforge.pmd.ast.ASTSynchronizedStatement;
import net.sourceforge.pmd.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.properties.BooleanProperty;
import net.sourceforge.pmd.symboltable.NameOccurrence;

public class SingularField
extends AbstractRule {
    private static final PropertyDescriptor CHECK_INNER_CLASSES = new BooleanProperty("CheckInnerClasses", "Check inner classes", false, 1.0f);
    private static final PropertyDescriptor DISALLOW_NOT_ASSIGNMENT = new BooleanProperty("DisallowNotAssignment", "Disallow violations where the first usage is not an assignment", false, 1.0f);
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTInitializer;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTIfStatement;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTStatementExpression;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTVariableDeclaratorId;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTAssignmentOperator;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTConstructorDeclaration;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTMethodDeclaration;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTPrimaryExpression;

    public Object visit(ASTFieldDeclaration node, Object data) {
        boolean checkInnerClasses = this.getBooleanProperty(CHECK_INNER_CLASSES);
        boolean disallowNotAssignment = this.getBooleanProperty(DISALLOW_NOT_ASSIGNMENT);
        if (node.isPrivate() && !node.isStatic()) {
            Class<?> clazz = class$net$sourceforge$pmd$ast$ASTVariableDeclaratorId;
            if (clazz == null) {
                clazz = class$net$sourceforge$pmd$ast$ASTVariableDeclaratorId = new ASTVariableDeclaratorId[0].getClass().getComponentType();
            }
            List list = node.findChildrenOfType(clazz);
            ASTVariableDeclaratorId declaration = (ASTVariableDeclaratorId)list.get(0);
            List<NameOccurrence> usages = declaration.getUsages();
            SimpleNode decl = null;
            boolean violation = true;
            for (int ix = 0; ix < usages.size(); ++ix) {
                SimpleNode method;
                NameOccurrence no = usages.get(ix);
                SimpleNode location = no.getLocation();
                Class<?> clazz2 = class$net$sourceforge$pmd$ast$ASTPrimaryExpression;
                if (clazz2 == null) {
                    clazz2 = new ASTPrimaryExpression[0].getClass().getComponentType();
                }
                ASTPrimaryExpression primaryExpressionParent = (ASTPrimaryExpression)location.getFirstParentOfType(clazz2);
                if (ix == 0 && !disallowNotAssignment) {
                    Class<?> clazz3 = class$net$sourceforge$pmd$ast$ASTIfStatement;
                    if (clazz3 == null) {
                        clazz3 = new ASTIfStatement[0].getClass().getComponentType();
                    }
                    if (primaryExpressionParent.getFirstParentOfType(clazz3) != null) {
                        violation = false;
                        break;
                    }
                    Node potentialStatement = primaryExpressionParent.jjtGetParent();
                    boolean assignmentToField = no.getImage().equals(location.getImage());
                    if (!assignmentToField || !this.isInAssignment(potentialStatement)) {
                        violation = false;
                        break;
                    }
                    if (usages.size() > ix + 1) {
                        SimpleNode secondUsageLocation = usages.get(ix + 1).getLocation();
                        Class<?> clazz4 = class$net$sourceforge$pmd$ast$ASTStatementExpression;
                        if (clazz4 == null) {
                            clazz4 = new ASTStatementExpression[0].getClass().getComponentType();
                        }
                        List parentStatements = secondUsageLocation.getParentsOfType(clazz4);
                        Iterator i$ = parentStatements.iterator();
                        while (i$.hasNext()) {
                            ASTStatementExpression statementExpression = (ASTStatementExpression)i$.next();
                            if (statementExpression == null || !statementExpression.equals(potentialStatement)) continue;
                            violation = false;
                            break;
                        }
                    }
                }
                if (!checkInnerClasses) {
                    ASTClassOrInterfaceDeclaration clazz5;
                    Class<?> clazz6 = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration;
                    if (clazz6 == null) {
                        clazz6 = new ASTClassOrInterfaceDeclaration[0].getClass().getComponentType();
                    }
                    if ((clazz5 = (ASTClassOrInterfaceDeclaration)location.getFirstParentOfType(clazz6)) != null) {
                        Class<?> clazz7 = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration;
                        if (clazz7 == null) {
                            clazz7 = new ASTClassOrInterfaceDeclaration[0].getClass().getComponentType();
                        }
                        if (clazz5.getFirstParentOfType(clazz7) != null) {
                            violation = false;
                            break;
                        }
                    }
                }
                if (primaryExpressionParent.jjtGetParent() instanceof ASTSynchronizedStatement) {
                    violation = false;
                    break;
                }
                Class<?> clazz8 = class$net$sourceforge$pmd$ast$ASTMethodDeclaration;
                if (clazz8 == null) {
                    clazz8 = new ASTMethodDeclaration[0].getClass().getComponentType();
                }
                if ((method = (SimpleNode)location.getFirstParentOfType(clazz8)) == null) {
                    Class<?> clazz9 = class$net$sourceforge$pmd$ast$ASTConstructorDeclaration;
                    if (clazz9 == null) {
                        clazz9 = new ASTConstructorDeclaration[0].getClass().getComponentType();
                    }
                    if ((method = (SimpleNode)location.getFirstParentOfType(clazz9)) == null) {
                        Class<?> clazz10 = class$net$sourceforge$pmd$ast$ASTInitializer;
                        if (clazz10 == null) {
                            clazz10 = new ASTInitializer[0].getClass().getComponentType();
                        }
                        if ((method = (SimpleNode)location.getFirstParentOfType(clazz10)) == null) continue;
                    }
                }
                if (decl == null) {
                    decl = method;
                    continue;
                }
                if (decl == method) continue;
                violation = false;
                break;
            }
            if (violation && !usages.isEmpty()) {
                this.addViolation(data, (Node)node, new Object[]{declaration.getImage()});
            }
        }
        return data;
    }

    private boolean isInAssignment(Node potentialStatement) {
        if (potentialStatement instanceof ASTStatementExpression) {
            ASTStatementExpression statement = (ASTStatementExpression)potentialStatement;
            ArrayList assignments = new ArrayList();
            Class<?> clazz = class$net$sourceforge$pmd$ast$ASTAssignmentOperator;
            if (clazz == null) {
                clazz = class$net$sourceforge$pmd$ast$ASTAssignmentOperator = new ASTAssignmentOperator[0].getClass().getComponentType();
            }
            statement.findChildrenOfType(clazz, assignments, false);
            return !assignments.isEmpty() && "=".equals(((ASTAssignmentOperator)assignments.get(0)).getImage());
        }
        return false;
    }
}

