/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.convert.service;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.springframework.binding.convert.ConversionException;
import org.springframework.binding.convert.ConversionExecutor;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.convert.Converter;
import org.springframework.binding.convert.service.NoOpConverter;
import org.springframework.binding.convert.service.StaticConversionExecutor;
import org.springframework.util.Assert;

public class GenericConversionService
implements ConversionService {
    private Map sourceClassConverters = new HashMap();
    private ConversionService parent;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;
    static /* synthetic */ Class class$15;

    public ConversionService getParent() {
        return this.parent;
    }

    public void setParent(ConversionService parent) {
        this.parent = parent;
    }

    public void addConverter(Converter converter) {
        Class[] sourceClasses = converter.getSourceClasses();
        Class[] targetClasses = converter.getTargetClasses();
        int i = 0;
        while (i < sourceClasses.length) {
            Class sourceClass = sourceClasses[i];
            HashMap<Class, Converter> sourceMap = (HashMap<Class, Converter>)this.sourceClassConverters.get(sourceClass);
            if (sourceMap == null) {
                sourceMap = new HashMap<Class, Converter>();
                this.sourceClassConverters.put(sourceClass, sourceMap);
            }
            int j = 0;
            while (j < targetClasses.length) {
                Class targetClass = targetClasses[j];
                sourceMap.put(targetClass, converter);
                ++j;
            }
            ++i;
        }
    }

    public ConversionExecutor getConversionExecutor(Class sourceClass, Class targetClass) throws ConversionException {
        Assert.notNull((Object)sourceClass, (String)"The source class to convert from is required");
        Assert.notNull((Object)targetClass, (String)"The target class to convert to is required");
        if (this.sourceClassConverters == null || this.sourceClassConverters.isEmpty()) {
            throw new IllegalStateException("No converters have been added to this service's registry");
        }
        sourceClass = this.convertToWrapperClassIfNecessary(sourceClass);
        if ((targetClass = this.convertToWrapperClassIfNecessary(targetClass)).isAssignableFrom(sourceClass)) {
            return new StaticConversionExecutor(sourceClass, targetClass, new NoOpConverter(sourceClass, targetClass));
        }
        Map sourceTargetConverters = this.findConvertersForSource(sourceClass);
        Converter converter = this.findTargetConverter(sourceTargetConverters, targetClass);
        if (converter != null) {
            return new StaticConversionExecutor(sourceClass, targetClass, converter);
        }
        if (this.parent != null) {
            return this.parent.getConversionExecutor(sourceClass, targetClass);
        }
        throw new ConversionException(sourceClass, targetClass, "No converter registered to convert from sourceClass '" + sourceClass + "' to target class '" + targetClass + "'");
    }

    protected Map getSourceClassConverters() {
        return this.sourceClassConverters;
    }

    protected Converter getConverter(Class sourceClass, Class targetClass) {
        Map sourceTargetConverters = this.findConvertersForSource(sourceClass);
        return this.findTargetConverter(sourceTargetConverters, targetClass);
    }

    private Map findConvertersForSource(Class sourceClass) {
        LinkedList classQueue = new LinkedList();
        classQueue.addFirst(sourceClass);
        while (!classQueue.isEmpty()) {
            sourceClass = (Class)classQueue.removeLast();
            Map sourceTargetConverters = (Map)this.sourceClassConverters.get(sourceClass);
            if (sourceTargetConverters != null && !sourceTargetConverters.isEmpty()) {
                return sourceTargetConverters;
            }
            if (!sourceClass.isInterface() && sourceClass.getSuperclass() != null) {
                classQueue.addFirst(sourceClass.getSuperclass());
            }
            Class<?>[] interfaces = sourceClass.getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                classQueue.addFirst(interfaces[i]);
                ++i;
            }
        }
        return Collections.EMPTY_MAP;
    }

    private Converter findTargetConverter(Map sourceTargetConverters, Class targetClass) {
        LinkedList classQueue = new LinkedList();
        classQueue.addFirst(targetClass);
        while (!classQueue.isEmpty()) {
            targetClass = (Class)classQueue.removeLast();
            Converter converter = (Converter)sourceTargetConverters.get(targetClass);
            if (converter != null) {
                return converter;
            }
            if (!targetClass.isInterface() && targetClass.getSuperclass() != null) {
                classQueue.addFirst(targetClass.getSuperclass());
            }
            Class<?>[] interfaces = targetClass.getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                classQueue.addFirst(interfaces[i]);
                ++i;
            }
        }
        return null;
    }

    private Class convertToWrapperClassIfNecessary(Class targetType) {
        if (targetType.isPrimitive()) {
            if (targetType.equals(Integer.TYPE)) {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            if (targetType.equals(Short.TYPE)) {
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = class$3 = Class.forName("java.lang.Short");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            if (targetType.equals(Long.TYPE)) {
                Class<?> clazz = class$5;
                if (clazz == null) {
                    try {
                        clazz = class$5 = Class.forName("java.lang.Long");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            if (targetType.equals(Float.TYPE)) {
                Class<?> clazz = class$7;
                if (clazz == null) {
                    try {
                        clazz = class$7 = Class.forName("java.lang.Float");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            if (targetType.equals(Double.TYPE)) {
                Class<?> clazz = class$9;
                if (clazz == null) {
                    try {
                        clazz = class$9 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            if (targetType.equals(Byte.TYPE)) {
                Class<?> clazz = class$11;
                if (clazz == null) {
                    try {
                        clazz = class$11 = Class.forName("java.lang.Byte");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            if (targetType.equals(Boolean.TYPE)) {
                Class<?> clazz = class$13;
                if (clazz == null) {
                    try {
                        clazz = class$13 = Class.forName("java.lang.Boolean");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            if (targetType.equals(Character.TYPE)) {
                Class<?> clazz = class$15;
                if (clazz == null) {
                    try {
                        clazz = class$15 = Class.forName("java.lang.Character");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            throw new IllegalStateException("Should never happen - primitive type is not a primitive?");
        }
        return targetType;
    }
}

