/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.fdl.filehandling;

import egovframework.rte.fdl.logging.util.EgovResourceReleaser;
import egovframework.rte.fdl.string.EgovStringUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.VFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EgovFileUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(EgovFileUtil.class);
    private static final int BUFFER_SIZE = 1024;
    private static FileObject basefile;
    private static FileSystemManager manager;

    public static int rm(String cmd) throws FileSystemException {
        int result = -1;
        try {
            FileObject file = manager.resolveFile(basefile, cmd);
            result = file.delete(Selectors.SELECT_SELF_AND_CHILDREN);
            LOGGER.debug("result is {}", (Object)result);
        }
        catch (FileSystemException e) {
            LOGGER.error(e.toString());
            throw new FileSystemException((Throwable)e);
        }
        return result;
    }

    public static void cp(String source, String target) throws Exception {
        try {
            FileObject src = manager.resolveFile(basefile, source);
            FileObject dest = manager.resolveFile(basefile, target);
            if (dest.exists() && dest.getType() == FileType.FOLDER) {
                dest = dest.resolveFile(src.getName().getBaseName());
            }
            dest.copyFrom(src, Selectors.SELECT_ALL);
        }
        catch (FileSystemException fse) {
            LOGGER.error(fse.toString());
            throw new FileSystemException((Throwable)fse);
        }
    }

    public static void mv(String source, String target) throws Exception {
        try {
            FileObject src = manager.resolveFile(basefile, source);
            FileObject dest = manager.resolveFile(basefile, target);
            if (dest.exists() && dest.getType() == FileType.FOLDER) {
                dest = dest.resolveFile(src.getName().getBaseName());
            }
            src.moveTo(dest);
        }
        catch (FileSystemException fse) {
            LOGGER.error(fse.toString());
            throw new FileSystemException((Throwable)fse);
        }
    }

    public static FileName pwd() {
        return basefile.getName();
    }

    public static long touch(String filepath) throws Exception {
        long currentTime = 0L;
        FileObject file = manager.resolveFile(basefile, filepath);
        if (!file.exists()) {
            file.createFile();
        }
        currentTime = System.currentTimeMillis();
        file.getContent().setLastModifiedTime(currentTime);
        return currentTime;
    }

    public static void cd(String changDirectory) throws Exception {
        String path = !EgovStringUtil.isNull((String)changDirectory) ? changDirectory : System.getProperty("user.home");
        FileObject tmp = manager.resolveFile(basefile, path);
        if (tmp.exists()) {
            basefile = tmp;
        } else {
            LOGGER.info("Folder does not exist: {}", (Object)tmp.getName());
        }
        LOGGER.info("Current folder is {}", (Object)basefile.getName());
    }

    public List<?> ls(String[] cmd) throws FileSystemException {
        boolean recursive;
        ArrayList list = new ArrayList();
        int pos = 1;
        if (cmd.length > pos && cmd[pos].equals("-R")) {
            recursive = true;
            ++pos;
        } else {
            recursive = false;
        }
        FileObject file = cmd.length > pos ? manager.resolveFile(basefile, cmd[pos]) : basefile;
        if (file.getType() == FileType.FOLDER) {
            LOGGER.info("Contents of {}", (Object)file.getName());
            LOGGER.info("info: {}", (Object)this.listChildren(file, recursive, ""));
        } else {
            LOGGER.info("info: {}", (Object)file.getName());
            FileContent content = file.getContent();
            LOGGER.info("Size: {}bytes.", (Object)content.getSize());
            DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2);
            String lastMod = dateFormat.format(new Date(content.getLastModifiedTime()));
            LOGGER.info("Last modified: {}", (Object)lastMod);
        }
        return list;
    }

    private StringBuffer listChildren(FileObject dir, boolean recursive, String prefix) throws FileSystemException {
        StringBuffer line = new StringBuffer();
        FileObject[] children = dir.getChildren();
        for (int i = 0; i < children.length; ++i) {
            FileObject child = children[i];
            line.append(prefix).append(child.getName().getBaseName());
            if (child.getType() == FileType.FOLDER) {
                line.append("/");
                if (!recursive) continue;
                line.append(this.listChildren(child, recursive, prefix + "    "));
                continue;
            }
            line.append("");
        }
        return line;
    }

    public static String readFile(File file) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        return EgovFileUtil.readFileContent(in);
    }

    public static String readFileContent(InputStream in) throws IOException {
        StringBuffer buf = new StringBuffer();
        int i = in.read();
        while (i != -1) {
            buf.append((char)i);
            i = in.read();
        }
        return buf.toString();
    }

    public static String readFile(File file, String encoding) throws IOException {
        StringBuffer sb = new StringBuffer();
        List lines = FileUtils.readLines((File)file, (String)encoding);
        Iterator it = lines.iterator();
        while (true) {
            sb.append((String)it.next());
            if (!it.hasNext()) break;
            sb.append("");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(File file, String text) {
        FileWriter writer = null;
        try {
            writer = new FileWriter(file);
            writer.write(text);
        }
        catch (Exception e) {
            try {
                LOGGER.error("Error creating File: {} : {}", (Object)file.getName(), (Object)e);
            }
            catch (Throwable throwable) {
                EgovResourceReleaser.close((Closeable[])new Closeable[]{writer});
                throw throwable;
            }
            EgovResourceReleaser.close((Closeable[])new Closeable[]{writer});
            return;
        }
        EgovResourceReleaser.close((Closeable[])new Closeable[]{writer});
    }

    public static void writeFile(String fileName, String text) {
        EgovFileUtil.writeFile(new File(fileName), text);
    }

    public static void writeFile(String fileName, String data, String encoding) throws IOException {
        FileUtils.writeStringToFile((File)new File(fileName), (String)data, (String)encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getContent(FileObject file) throws IOException {
        FileContent content = file.getContent();
        int size = (int)content.getSize();
        byte[] buf = new byte[size];
        InputStream in = content.getInputStream();
        try {
            int read = 0;
            for (int pos = 0; pos < size && read >= 0; pos += read) {
                read = in.read(buf, pos, size - pos);
            }
        }
        catch (Throwable throwable) {
            EgovResourceReleaser.close((Closeable[])new Closeable[]{in});
            throw throwable;
        }
        EgovResourceReleaser.close((Closeable[])new Closeable[]{in});
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeContent(FileObject file, OutputStream outstr) throws IOException {
        InputStream instr = file.getContent().getInputStream();
        try {
            int nread;
            byte[] buffer = new byte[1024];
            while ((nread = instr.read(buffer)) >= 0) {
                outstr.write(buffer, 0, nread);
            }
        }
        catch (Throwable throwable) {
            EgovResourceReleaser.close((Closeable[])new Closeable[]{instr});
            throw throwable;
        }
        EgovResourceReleaser.close((Closeable[])new Closeable[]{instr});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyContent(FileObject srcFile, FileObject destFile) throws IOException {
        OutputStream outstr = destFile.getContent().getOutputStream();
        try {
            EgovFileUtil.writeContent(srcFile, outstr);
        }
        catch (Throwable throwable) {
            EgovResourceReleaser.close((Closeable[])new Closeable[]{outstr});
            throw throwable;
        }
        EgovResourceReleaser.close((Closeable[])new Closeable[]{outstr});
    }

    public static String getFileExtension(String filename) {
        return FilenameUtils.getExtension((String)filename);
    }

    public static boolean isExistsFile(String filename) {
        File file = new File(filename);
        return file.exists();
    }

    public static String stripFilename(String filename) {
        return FilenameUtils.getBaseName((String)filename);
    }

    public static void delete(File file) throws IOException {
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            for (int i = 0; i < children.length; ++i) {
                EgovFileUtil.delete(children[i]);
            }
        }
        if (!file.delete()) {
            throw new IOException("Unable to delete " + file.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuffer readTextFile(String fileName, boolean newline) throws FileNotFoundException, IOException {
        File file = new File(fileName);
        if (!file.exists()) {
            throw new FileNotFoundException();
        }
        StringBuffer buf = new StringBuffer();
        BufferedReader in = null;
        try {
            String str;
            in = new BufferedReader(new FileReader(file));
            while ((str = in.readLine()) != null) {
                buf.append(str);
                if (!newline) continue;
                buf.append(System.getProperty("line.separator"));
            }
        }
        catch (Throwable throwable) {
            EgovResourceReleaser.close((Closeable[])new Closeable[]{in});
            throw throwable;
        }
        EgovResourceReleaser.close((Closeable[])new Closeable[]{in});
        return buf;
    }

    public static FileObject getFileObject(String filepath) throws Exception {
        FileSystemManager mgr = VFS.getManager();
        return mgr.resolveFile(mgr.resolveFile(System.getProperty("user.dir")), filepath);
    }

    public static List<String> grep(Object[] search, String pattern) throws Exception {
        Pattern searchPattern = Pattern.compile(pattern);
        String[] strings = searchPattern.split(search.toString());
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < strings.length; ++i) {
            list.add(strings[i]);
        }
        return list;
    }

    public static List<String> grep(File file, String pattern) throws Exception {
        Pattern searchPattern = Pattern.compile(pattern);
        List lists = FileUtils.readLines((File)file);
        Object[] search = lists.toArray();
        String[] strings = searchPattern.split(search.toString());
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < strings.length; ++i) {
            list.add(strings[i]);
        }
        return list;
    }

    public static String getTmpDirectory() throws IOException {
        File baseDir = new File(System.getProperty("java.io.tmpdir"));
        return baseDir.getCanonicalPath();
    }

    static {
        try {
            manager = VFS.getManager();
            basefile = manager.resolveFile(System.getProperty("user.dir"));
            LOGGER.debug("basefile : {}", (Object)basefile);
        }
        catch (FileSystemException e) {
            LOGGER.error("EgovFileUtil : {}", (Object)e.getMessage());
        }
    }
}

