/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.bat.core.item.file.transform;

import egovframework.rte.bat.core.item.file.transform.EgovAbstractLineTokenizer;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EgovDelimitedLineTokenizer
extends EgovAbstractLineTokenizer {
    public static final String DELIMITER_COMMA = ",";
    public static final String DEFAULT_QUOTE_CHARACTER = "\"";
    private String delimiter;
    private String quoteCharacter = "\"";

    public EgovDelimitedLineTokenizer() {
        this(DELIMITER_COMMA);
    }

    public EgovDelimitedLineTokenizer(String delimiter) {
        Assert.state((delimiter != DEFAULT_QUOTE_CHARACTER ? 1 : 0) != 0, (String)"[\"] is not allowed as delimiter for tokenizers.");
        this.delimiter = delimiter;
        this.setQuoteCharacter(DEFAULT_QUOTE_CHARACTER);
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public final void setQuoteCharacter(String quoteCharacter) {
        this.quoteCharacter = quoteCharacter;
    }

    @Override
    public List<String> doTokenize(String line) {
        ArrayList<String> tokens = new ArrayList<String>();
        int beginIndex = 0;
        int delimiterIndex = 0;
        int quoteIndex = line.indexOf(this.quoteCharacter, beginIndex);
        int endQuoteIndex = 0;
        int lastCut = 0;
        int length = line.length();
        while (lastCut != length && lastCut != -1) {
            delimiterIndex = line.indexOf(this.delimiter, beginIndex);
            if (quoteIndex == -1) {
                lastCut = delimiterIndex != -1 ? delimiterIndex : length;
                tokens.add(line.substring(beginIndex, lastCut));
                beginIndex = lastCut + 1;
                continue;
            }
            if (quoteIndex < delimiterIndex) {
                endQuoteIndex = line.indexOf(this.quoteCharacter, quoteIndex + 1);
                if (endQuoteIndex != -1) {
                    tokens.add(line.substring(quoteIndex + 1, endQuoteIndex));
                    if (line.indexOf(this.quoteCharacter, endQuoteIndex) != -1) {
                        lastCut = line.indexOf(this.delimiter, endQuoteIndex);
                        beginIndex = lastCut + 1;
                    }
                } else {
                    lastCut = length;
                    tokens.add(line.substring(beginIndex, lastCut));
                }
            } else {
                lastCut = delimiterIndex != -1 ? delimiterIndex : length;
                tokens.add(line.substring(beginIndex, lastCut));
                beginIndex = lastCut + 1;
            }
            quoteIndex = line.indexOf(this.quoteCharacter, beginIndex);
        }
        return tokens;
    }
}

