/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.itl.integration.type.support;

import egovframework.rte.itl.integration.metadata.RecordTypeDefinition;
import egovframework.rte.itl.integration.metadata.RecordTypeFieldDefinition;
import egovframework.rte.itl.integration.metadata.dao.RecordTypeDefinitionDao;
import egovframework.rte.itl.integration.type.CircularInheritanceException;
import egovframework.rte.itl.integration.type.ListType;
import egovframework.rte.itl.integration.type.NoSuchTypeException;
import egovframework.rte.itl.integration.type.PrimitiveType;
import egovframework.rte.itl.integration.type.RecordType;
import egovframework.rte.itl.integration.type.Type;
import egovframework.rte.itl.integration.type.TypeLoader;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class TypeLoaderUsingMetadata
implements TypeLoader,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(TypeLoaderUsingMetadata.class);
    private RecordTypeDefinitionDao recordTypeDefinitionDao;
    private Map<String, Type> typePool = new HashMap<String, Type>();

    public TypeLoaderUsingMetadata() {
    }

    public TypeLoaderUsingMetadata(RecordTypeDefinitionDao recordTypeDefinitionDao) {
        this.recordTypeDefinitionDao = recordTypeDefinitionDao;
    }

    public void setRecordTypeDefinitionDao(RecordTypeDefinitionDao recordTypeDefinitionDao) {
        this.recordTypeDefinitionDao = recordTypeDefinitionDao;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.recordTypeDefinitionDao == null) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public Type getType(String id) {
        return this.getType(id, null);
    }

    private Type getType(String id, Map<String, Type> loadingTypes) {
        LOGGER.debug("get Type(id = \"{}\")", (Object)id);
        if (id == null) {
            LOGGER.error("Argument 'id' is null");
            throw new NoSuchTypeException();
        }
        Type type = null;
        if (loadingTypes != null && (type = loadingTypes.get(id)) != null) {
            LOGGER.debug("Type(id = \"{}\") exists in load hierachy : {}", (Object)id, (Object)type);
            return type;
        }
        type = PrimitiveType.getPrimitiveType(id);
        if (type != null) {
            LOGGER.debug("Type(id = \"{}\") is a primitive type : {}", (Object)id, (Object)type);
            return type;
        }
        type = this.typePool.get(id);
        if (type != null) {
            LOGGER.debug("Type(id = \"{}\") is already loaded : {}", (Object)id, (Object)type);
            return type;
        }
        LOGGER.debug("Load new type(id= \"{}\"", (Object)id);
        if (loadingTypes == null) {
            loadingTypes = new HashMap<String, Type>();
        }
        if (id.endsWith("[]")) {
            LOGGER.debug("Type(id = \"{}\") is a list type", (Object)id);
            type = new ListType(id, id, PrimitiveType.BOOLEAN);
            loadingTypes.put(id, type);
            Type elementType = this.getType(id.substring(0, id.length() - 2), loadingTypes);
            LOGGER.debug("ListType(id = \"{}\")'s elementType = {}", (Object)id, (Object)elementType);
            ((ListType)type).setElementType(elementType);
            loadingTypes.remove(id);
        } else {
            LOGGER.debug("Type(id = \"{}\") is a record type", (Object)id);
            RecordTypeDefinition recordTypeDefinition = this.recordTypeDefinitionDao.getRecordTypeDefinition(id);
            if (recordTypeDefinition == null) {
                LOGGER.error("No Such RecordTypeDefinition(id = \"{}\"", (Object)id);
                throw new NoSuchTypeException();
            }
            if (!recordTypeDefinition.isValid()) {
                LOGGER.error("RecordTypeDefinition(id = \"{}\" is invalid", (Object)id);
                throw new NoSuchTypeException();
            }
            type = new RecordType(id, recordTypeDefinition.getName());
            loadingTypes.put(id, type);
            HashMap<String, RecordTypeDefinition> occurredTypes = new HashMap<String, RecordTypeDefinition>();
            HashMap<String, Type> fieldTypes = new HashMap<String, Type>();
            for (RecordTypeDefinition currentRecordTypeDefinition = recordTypeDefinition; currentRecordTypeDefinition != null; currentRecordTypeDefinition = currentRecordTypeDefinition.getParent()) {
                if (occurredTypes.containsKey(currentRecordTypeDefinition.getId())) {
                    throw new CircularInheritanceException();
                }
                occurredTypes.put(currentRecordTypeDefinition.getId(), currentRecordTypeDefinition);
                for (Map.Entry<Object, Object> entry : currentRecordTypeDefinition.getFields().entrySet()) {
                    if (fieldTypes.containsKey(entry.getKey())) continue;
                    fieldTypes.put((String)entry.getKey(), this.getType(((RecordTypeFieldDefinition)entry.getValue()).getTypeId(), loadingTypes));
                }
            }
            if (LOGGER.isDebugEnabled()) {
                for (Map.Entry entry : fieldTypes.entrySet()) {
                    LOGGER.debug("RecordType(id = \"{}\")'s field[{}] type = {}", new Object[]{id, entry.getKey(), entry.getValue()});
                }
            }
            ((RecordType)type).setFieldTypes(fieldTypes);
            loadingTypes.remove(id);
        }
        this.typePool.put(id, type);
        return type;
    }
}

