/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.itl.integration.support;

import egovframework.rte.itl.integration.EgovIntegrationMessage;
import egovframework.rte.itl.integration.EgovIntegrationServiceCallback;
import egovframework.rte.itl.integration.support.AbstractService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MessageSender
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageSender.class);
    protected AbstractService service;
    protected EgovIntegrationMessage requestMessage;
    protected EgovIntegrationMessage responseMessage = null;
    protected EgovIntegrationServiceCallback callback = null;

    public MessageSender(AbstractService service, EgovIntegrationMessage requestMessage, EgovIntegrationServiceCallback callback) {
        this.service = service;
        this.requestMessage = requestMessage;
        this.callback = callback;
    }

    public EgovIntegrationMessage getResponseMessage() {
        return this.responseMessage;
    }

    @Override
    public void run() {
        LOGGER.debug("MessageSender just Start");
        EgovIntegrationServiceCallback.CallbackId callbackId = null;
        if (this.callback != null) {
            callbackId = this.callback.createId(this.service, this.requestMessage);
            LOGGER.debug("Create CallbackId(" + callbackId + ")");
        }
        LOGGER.debug("Send and Receive Messages");
        this.responseMessage = this.service.doSend(this.requestMessage);
        if (this.callback != null) {
            LOGGER.debug("Notify to callback");
            this.callback.onReceive(callbackId, this.responseMessage);
        }
    }
}

