/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.psl.dataaccess.typehandler;

import com.ibatis.sqlmap.client.extensions.ParameterSetter;
import com.ibatis.sqlmap.client.extensions.ResultGetter;
import com.ibatis.sqlmap.client.extensions.TypeHandlerCallback;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class StringTimestampTypeHandler
implements TypeHandlerCallback {
    private static final String DATE_FORMAT = "yyyyMMddHHmmss";
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyyMMddHHmmss", Locale.getDefault());

    public Object getResult(ResultGetter getter) throws SQLException {
        if (getter.wasNull()) {
            return null;
        }
        Timestamp ts = getter.getTimestamp();
        return SDF.format(ts);
    }

    public void setParameter(ParameterSetter setter, Object parameter) throws SQLException {
        if (parameter == null) {
            setter.setNull(91);
        } else {
            try {
                Timestamp ts = new Timestamp(SDF.parse((String)parameter).getTime());
                setter.setTimestamp(ts);
            }
            catch (ParseException e) {
                throw new SQLException("Error parsing string to timestamp.  Cause: " + e.getMessage());
            }
        }
    }

    public Object valueOf(String s) {
        return s;
    }
}

