/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.fdl.string;

import java.lang.reflect.Constructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EgovObjectUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(EgovObjectUtil.class);

    private EgovObjectUtil() {
    }

    public static Class<?> loadClass(String className) throws ClassNotFoundException, Exception {
        Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
        if (clazz == null) {
            clazz = Class.forName(className);
        }
        return clazz;
    }

    public static Object instantiate(String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException, Exception {
        try {
            Class<?> clazz = EgovObjectUtil.loadClass(className);
            return clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("{} : Class is can not instantialized.", (Object)className);
            throw new ClassNotFoundException();
        }
        catch (InstantiationException e) {
            LOGGER.error("{} : Class is can not instantialized.", (Object)className);
            throw new InstantiationException();
        }
        catch (IllegalAccessException e) {
            LOGGER.error("{} : Class is not accessed.", (Object)className);
            throw new IllegalAccessException();
        }
        catch (Exception e) {
            LOGGER.error("{} : Class is not accessed.", (Object)className);
            throw new Exception(e);
        }
    }

    public static Object instantiate(String className, String[] types, Object[] values) throws ClassNotFoundException, InstantiationException, IllegalAccessException, Exception {
        Class[] classParams = new Class[values.length];
        Object[] objectParams = new Object[values.length];
        try {
            Class<?> clazz = EgovObjectUtil.loadClass(className);
            for (int i = 0; i < values.length; ++i) {
                classParams[i] = EgovObjectUtil.loadClass(types[i]);
                objectParams[i] = values[i];
            }
            Constructor<?> constructor = clazz.getConstructor(classParams);
            return constructor.newInstance(values);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("{} : Class is can not instantialized.", (Object)className);
            throw new ClassNotFoundException();
        }
        catch (InstantiationException e) {
            LOGGER.error("{} : Class is can not instantialized.", (Object)className);
            throw new InstantiationException();
        }
        catch (IllegalAccessException e) {
            LOGGER.error("{} : Class is not accessed.", (Object)className);
            throw new IllegalAccessException();
        }
        catch (Exception e) {
            LOGGER.error("{} : Class is not accessed.", (Object)className);
            throw new Exception(e);
        }
    }

    public static boolean isNull(Object object) {
        return object == null || object.equals(null);
    }
}

