/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.repeat.support;

import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.batch.repeat.support.ResultHolder;
import org.springframework.batch.repeat.support.ResultQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultHolderResultQueue
implements ResultQueue<ResultHolder> {
    private final BlockingQueue<ResultHolder> results;
    private final Semaphore waits;
    private final Object lock = new Object();
    private volatile int count = 0;

    public ResultHolderResultQueue(int throttleLimit) {
        this.results = new PriorityBlockingQueue<ResultHolder>(throttleLimit, new ResultHolderComparator());
        this.waits = new Semaphore(throttleLimit);
    }

    @Override
    public boolean isEmpty() {
        return this.results.isEmpty();
    }

    @Override
    public boolean isExpecting() {
        return this.count > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void expect() throws InterruptedException {
        this.waits.acquire();
        Object object = this.lock;
        synchronized (object) {
            ++this.count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(ResultHolder holder) throws IllegalArgumentException {
        if (!this.isExpecting()) {
            throw new IllegalArgumentException("Not expecting a result.  Call expect() before put().");
        }
        this.results.add(holder);
        this.waits.release();
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultHolder take() throws NoSuchElementException, InterruptedException {
        ResultHolder value;
        if (!this.isExpecting()) {
            throw new NoSuchElementException("Not expecting a result.  Call expect() before take().");
        }
        Object object = this.lock;
        synchronized (object) {
            value = this.results.take();
            if (this.isContinuable(value)) {
                --this.count;
                return value;
            }
        }
        this.results.put(value);
        object = this.lock;
        synchronized (object) {
            while (this.count > this.results.size()) {
                this.lock.wait();
            }
            value = this.results.take();
            --this.count;
        }
        return value;
    }

    private boolean isContinuable(ResultHolder value) {
        return value.getResult() != null && value.getResult().isContinuable();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResultHolderComparator
    implements Comparator<ResultHolder> {
        private ResultHolderComparator() {
        }

        @Override
        public int compare(ResultHolder h1, ResultHolder h2) {
            RepeatStatus result1 = h1.getResult();
            RepeatStatus result2 = h2.getResult();
            if (result1 == null && result2 == null) {
                return 0;
            }
            if (result1 == null) {
                return -1;
            }
            if (result2 == null) {
                return 1;
            }
            if (result1.isContinuable() && result2.isContinuable() || !result1.isContinuable() && !result2.isContinuable()) {
                return 0;
            }
            if (result1.isContinuable()) {
                return -1;
            }
            return 1;
        }
    }
}

