/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.fdl.xml;

import egovframework.rte.fdl.xml.AbstractXMLUtility;
import egovframework.rte.fdl.xml.error.ErrorChecker;
import egovframework.rte.fdl.xml.exception.ValidatorException;
import egovframework.rte.fdl.xml.impl.ContentHandlerImpl;
import java.util.Set;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class EgovSAXValidatorService
extends AbstractXMLUtility {
    public boolean parse(boolean isValid) throws ValidatorException {
        try {
            if (this.getXML() == null && this.getXMLFile() == null) {
                String message = null;
                message = isValid ? "XML Validation\uc744 \uccb4\ud06c\ud558\uae30 \uc704\ud55c XML\uc774 \ud544\uc694\ud569\ub2c8\ub2e4." : "Well-Formed\ub97c \uccb4\ud06c\ud558\uae30 \uc704\ud55c XML\uc774 \ud544\uc694\ud569\ub2c8\ub2e4.";
            }
            XMLReader parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            parser.setFeature("http://xml.org/sax/features/validation", isValid);
            if (this.getSCHEMAFile() != null) {
                parser.setFeature("http://apache.org/xml/features/validation/schema", true);
                parser.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
                parser.setProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", this.getSCHEMAFile());
            }
            ContentHandlerImpl contend = new ContentHandlerImpl();
            parser.setContentHandler(contend);
            ErrorChecker errors = new ErrorChecker();
            parser.setErrorHandler(errors);
            if (this.getXMLFile() != null) {
                parser.parse(this.getXMLFile());
            } else {
                parser.parse(this.stringToInputSource());
            }
            Set errorReport = errors.getErrorReport();
            if (errorReport.size() > 0) {
                this.makeErrorMessage(errorReport);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            throw new ValidatorException(e.getMessage());
        }
    }
}

