/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.fdl.security.userdetails.util;

import egovframework.rte.fdl.security.userdetails.EgovUserDetails;
import egovframework.rte.fdl.string.EgovObjectUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.encoding.ShaPasswordEncoder;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public final class EgovUserDetailsHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(EgovUserDetailsHelper.class);

    private EgovUserDetailsHelper() {
    }

    public static Object getAuthenticatedUser() {
        SecurityContext context = SecurityContextHolder.getContext();
        Authentication authentication = context.getAuthentication();
        if (EgovObjectUtil.isNull((Object)authentication)) {
            LOGGER.debug("## authentication object is null!!");
            return null;
        }
        if (authentication.getPrincipal() instanceof EgovUserDetails) {
            EgovUserDetails details = (EgovUserDetails)((Object)authentication.getPrincipal());
            LOGGER.debug("## EgovUserDetailsHelper.getAuthenticatedUser : AuthenticatedUser is {}", (Object)details.getUsername());
            return details.getEgovUserVO();
        }
        return authentication.getPrincipal();
    }

    public static List<String> getAuthorities() {
        ArrayList<String> listAuth = new ArrayList<String>();
        SecurityContext context = SecurityContextHolder.getContext();
        Authentication authentication = context.getAuthentication();
        if (EgovObjectUtil.isNull((Object)authentication)) {
            LOGGER.debug("## authentication object is null!!");
            return null;
        }
        Collection authorities = authentication.getAuthorities();
        for (GrantedAuthority auth : authorities) {
            listAuth.add(auth.getAuthority());
            LOGGER.debug("## EgovUserDetailsHelper.getAuthorities : Authority is {}", (Object)auth.getAuthority());
        }
        return listAuth;
    }

    public static Boolean isAuthenticated() {
        SecurityContext context = SecurityContextHolder.getContext();
        Authentication authentication = context.getAuthentication();
        if (EgovObjectUtil.isNull((Object)authentication)) {
            LOGGER.debug("## authentication object is null!!");
            return Boolean.FALSE;
        }
        String username = authentication.getName();
        if (username.equals("anonymousUser")) {
            LOGGER.debug("## username is {}", (Object)username);
            return Boolean.FALSE;
        }
        Object principal = authentication.getPrincipal();
        return !EgovObjectUtil.isNull((Object)principal);
    }

    public static String getHashedPassword(String password) {
        ShaPasswordEncoder encoder = new ShaPasswordEncoder(256);
        String hashed = encoder.encodePassword(password, null);
        return hashed;
    }
}

