/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.fdl.logging.util;

import java.util.logging.Level;
import java.util.logging.Logger;

public final class EgovJdkLogger {
    private static final Level IGNORE_INFO_LEVEL = Level.OFF;
    private static final Level DEBUG_INFO_LEVEL = Level.FINEST;
    private static final Level INFO_INFO_LEVEL = Level.INFO;
    private static final Logger IGNORE_LOGGER = Logger.getLogger("ignore");
    private static final Logger DEBUG_LOGGER = Logger.getLogger("debug");
    private static final Logger INFO_LOGGER = Logger.getLogger("info");

    private EgovJdkLogger() {
    }

    public static void ignore(String message, Exception exception) {
        if (exception == null) {
            IGNORE_LOGGER.log(IGNORE_INFO_LEVEL, message);
        } else {
            IGNORE_LOGGER.log(IGNORE_INFO_LEVEL, message, exception);
        }
    }

    public static void ignore(String message) {
        EgovJdkLogger.ignore(message, null);
    }

    public static void debug(String message, Exception exception) {
        if (exception == null) {
            DEBUG_LOGGER.log(DEBUG_INFO_LEVEL, message);
        } else {
            DEBUG_LOGGER.log(DEBUG_INFO_LEVEL, message, exception);
        }
    }

    public static void debug(String message) {
        EgovJdkLogger.debug(message, null);
    }

    public static void info(String message) {
        INFO_LOGGER.log(INFO_INFO_LEVEL, message);
    }
}

