/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.bat.core.item.database;

import egovframework.rte.bat.core.item.database.support.EgovItemPreparedStatementSetter;
import egovframework.rte.bat.core.reflection.EgovReflectionSupport;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.util.Assert;

public class EgovJdbcBatchItemWriter<T>
implements ItemWriter<T>,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(EgovJdbcBatchItemWriter.class);
    private JdbcOperations jdbcTemplate;
    private EgovItemPreparedStatementSetter<T> itemPreparedStatementSetter;
    private String sql;
    private String[] params = new String[0];
    private boolean assertUpdates = true;
    private boolean usingParameters;
    private EgovReflectionSupport<T> reflector;

    public void setAssertUpdates(boolean assertUpdates) {
        this.assertUpdates = assertUpdates;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void setItemPreparedStatementSetter(EgovItemPreparedStatementSetter<T> preparedStatementSetter) {
        this.itemPreparedStatementSetter = preparedStatementSetter;
    }

    public void setParams(String[] params) {
        this.params = params == null ? null : Arrays.asList(params).toArray(new String[params.length]);
    }

    public void setDataSource(DataSource dataSource) {
        if (this.jdbcTemplate == null) {
            this.jdbcTemplate = new JdbcTemplate(dataSource);
        }
    }

    public void setSimpleJdbcTemplate(JdbcOperations jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.jdbcTemplate, (String)"A DataSource or a SimpleJdbcTemplate is required.");
        Assert.notNull((Object)this.sql, (String)"An SQL statement is required.");
        if (this.params.length != 0) {
            this.usingParameters = true;
        }
        Assert.notNull(this.itemPreparedStatementSetter, (String)"Using SQL statement with '?' placeholders requires an EgovMethodMapItemPreparedStatementSetter");
        this.reflector = new EgovReflectionSupport();
    }

    public void write(final List<? extends T> items) throws Exception {
        if (!items.isEmpty()) {
            LOGGER.debug("Executing batch with {} items ", (Object)items.size());
            int[] updateCounts = null;
            updateCounts = (int[])this.jdbcTemplate.execute(this.sql, (PreparedStatementCallback)new PreparedStatementCallback<Object>(){

                public Object doInPreparedStatement(PreparedStatement ps) throws SQLException, DataAccessException {
                    if (EgovJdbcBatchItemWriter.this.usingParameters) {
                        String[] sqlTypes = EgovJdbcBatchItemWriter.this.reflector.getSqlTypeArray(EgovJdbcBatchItemWriter.this.params, items.get(0));
                        try {
                            EgovJdbcBatchItemWriter.this.reflector.generateGetterMethodMap(EgovJdbcBatchItemWriter.this.params, items.get(0));
                        }
                        catch (Exception e) {
                            LOGGER.error("error", (Throwable)e);
                        }
                        HashMap<String, Method> methodMap = EgovJdbcBatchItemWriter.this.reflector.getMethodMap();
                        for (Object item : items) {
                            EgovJdbcBatchItemWriter.this.itemPreparedStatementSetter.setValues(item, ps, EgovJdbcBatchItemWriter.this.params, sqlTypes, methodMap);
                            ps.addBatch();
                        }
                    } else {
                        for (Object item : items) {
                            EgovJdbcBatchItemWriter.this.itemPreparedStatementSetter.setValues(item, ps);
                            ps.addBatch();
                        }
                    }
                    return ps.executeBatch();
                }
            });
            if (this.assertUpdates) {
                for (int i = 0; i < updateCounts.length; ++i) {
                    int value = updateCounts[i];
                    if (value != 0) continue;
                    throw new EmptyResultDataAccessException("Item " + i + " of " + updateCounts.length + " did not update any rows: [" + items.get(i) + "]", 1);
                }
            }
        }
    }
}

