/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.itl.integration.metadata;

import egovframework.rte.itl.integration.metadata.SystemDefinition;
import egovframework.rte.itl.integration.util.Validatable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.util.StringUtils;

public class OrganizationDefinition
implements Validatable {
    private String id;
    private String name;
    private Map<String, SystemDefinition> systems = new HashMap<String, SystemDefinition>();
    private boolean valid = false;
    private AtomicBoolean statusChanged = new AtomicBoolean(false);

    public OrganizationDefinition() {
    }

    public OrganizationDefinition(String id, String name) {
        this.id = id;
        this.name = name;
        this.statusChanged.set(true);
    }

    public OrganizationDefinition(String id, String name, Map<String, SystemDefinition> systems) {
        this.id = id;
        this.name = name;
        this.systems = systems;
        this.statusChanged.set(true);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
        this.statusChanged.set(true);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.statusChanged.set(true);
    }

    public Map<String, SystemDefinition> getSystems() {
        return this.systems;
    }

    public void setSystems(Map<String, SystemDefinition> systems) {
        this.systems = systems;
        this.statusChanged.set(true);
    }

    public SystemDefinition getSystemDefinition(String systemId) {
        return this.systems.get(systemId);
    }

    @Override
    public boolean isValid() {
        if (this.statusChanged.getAndSet(false)) {
            boolean bl = this.valid = StringUtils.hasText((String)this.id) && StringUtils.hasText((String)this.name) && this.systems != null;
            if (this.systems != null) {
                for (SystemDefinition system : this.systems.values()) {
                    this.valid = this.valid && system.isValid();
                }
            }
        }
        return this.valid;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append(" {").append("\n\tid = ").append(StringUtils.quote((String)this.id)).append("\n\tname = ").append(StringUtils.quote((String)this.name));
        if (this.systems == null) {
            sb.append("\n\tsystems = null");
        } else {
            sb.append("\n\tsystems = {");
            for (Map.Entry<String, SystemDefinition> entry : this.systems.entrySet()) {
                sb.append("\n\t\t<key = ").append(StringUtils.quote((String)entry.getKey())).append(", value = ").append(entry.getValue() == null ? "" : "\n").append(entry.getValue()).append(">");
            }
            sb.append("\n\t}");
        }
        sb.append("\n}");
        return sb.toString();
    }
}

