/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.itl.integration.metadata.dao.hibernate;

import egovframework.rte.itl.integration.metadata.ServiceDefinition;
import egovframework.rte.itl.integration.metadata.dao.ServiceDefinitionDao;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class HibernateServiceDefinitionDao
extends HibernateDaoSupport
implements ServiceDefinitionDao {
    private static final Logger LOGGER = LoggerFactory.getLogger(HibernateServiceDefinitionDao.class);

    @Override
    public ServiceDefinition getServiceDefinition(String key) {
        LOGGER.debug("get ServiceDefinition(key = \"{}\")", (Object)key);
        ServiceDefinition serviceDefinition = (ServiceDefinition)this.getHibernateTemplate().get(ServiceDefinition.class, (Serializable)((Object)key));
        LOGGER.debug("get ServiceDefinition(key = \"{}\") = {}", (Object)key, (Object)serviceDefinition);
        return serviceDefinition;
    }

    @Override
    public ServiceDefinition getServiceDefinition(String systemKey, String serviceId) {
        LOGGER.debug("get ServiceDefinition(systemKey = \"{}\", serviceId = \"{}\")", (Object)systemKey, (Object)serviceId);
        ServiceDefinition serviceDefinition = null;
        List result = this.getHibernateTemplate().find("from ServiceDefinition as service where service.system.key = ? and service.id = ?", new Object[]{systemKey, serviceId});
        if (result != null && result.size() > 0) {
            serviceDefinition = (ServiceDefinition)result.get(0);
            if (result.size() != 1) {
                LOGGER.info("get ServiceDefinition(systemKey = \"{}\", serviceId = \"{}\")'s size is not 1 ({})", new Object[]{systemKey, serviceId, result.size()});
            }
        }
        LOGGER.debug("get ServiceDefinition(systemKey = \"{}\", serviceId = \"{}\") = {}", new Object[]{systemKey, serviceId, serviceDefinition});
        return serviceDefinition;
    }

    @Override
    public ServiceDefinition getServiceDefinition(String organizationId, String systemId, String serviceId) {
        LOGGER.debug("get ServiceDefinition(organizationId = \"{}\", systemId = \"{}\", serviceId = \"{}\")", new Object[]{organizationId, systemId, serviceId});
        ServiceDefinition serviceDefinition = null;
        List result = this.getHibernateTemplate().find("from ServiceDefinition as service where service.system.organization.id = ? and service.system.id = ? and service.id = ?", new Object[]{organizationId, systemId, serviceId});
        if (result != null && result.size() > 0) {
            serviceDefinition = (ServiceDefinition)result.get(0);
            if (result.size() != 1) {
                LOGGER.debug("get ServiceDefinition(organizationId = \"{}\", systemId = \"{}\", serviceId = \"{}\")'size is not 1 ({})", new Object[]{organizationId, systemId, serviceId, result.size()});
            }
        }
        LOGGER.debug("get ServiceDefinition(organizationId = \"{}\", systemId = \"{}\", serviceId = \"{}\") = {}", new Object[]{organizationId, systemId, serviceId, serviceDefinition});
        return serviceDefinition;
    }
}

