/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.itl.integration.support;

import egovframework.rte.itl.integration.EgovIntegrationMessage;
import egovframework.rte.itl.integration.EgovIntegrationMessageHeader;
import egovframework.rte.itl.integration.EgovIntegrationService;
import egovframework.rte.itl.integration.EgovIntegrationServiceCallback;
import egovframework.rte.itl.integration.EgovIntegrationServiceResponse;
import egovframework.rte.itl.integration.message.simple.SimpleMessage;
import egovframework.rte.itl.integration.message.simple.SimpleMessageHeader;
import egovframework.rte.itl.integration.support.DefaultResponse;
import egovframework.rte.itl.integration.support.MessageSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public abstract class AbstractService
implements EgovIntegrationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractService.class);
    protected String id;
    protected long defaultTimeout;

    public AbstractService(String id, long defaultTimeout) {
        if (!StringUtils.hasText((String)id)) {
            throw new IllegalArgumentException();
        }
        this.id = id;
        this.defaultTimeout = defaultTimeout;
    }

    @Override
    public long getDefaultTimeout() {
        return this.defaultTimeout;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public EgovIntegrationServiceResponse sendAsync(EgovIntegrationMessage requestMessage) {
        LOGGER.debug("sendAsync called without Callback");
        if (requestMessage == null) {
            LOGGER.error("requestMessage is null");
            throw new IllegalArgumentException();
        }
        LOGGER.debug("Create MessageSender without Callback");
        MessageSender sender = new MessageSender(this, requestMessage, null);
        LOGGER.debug("Start MessageSender");
        sender.start();
        return new DefaultResponse(sender, this.defaultTimeout);
    }

    @Override
    public void sendAsync(EgovIntegrationMessage requestMessage, EgovIntegrationServiceCallback callback) {
        LOGGER.debug("sendAsync called with Callback");
        if (requestMessage == null) {
            LOGGER.error("requestMessage is null");
            throw new IllegalArgumentException();
        }
        if (callback == null) {
            LOGGER.error("callback is null");
            throw new IllegalArgumentException();
        }
        LOGGER.debug("Create MessageSender with Callback");
        MessageSender sender = new MessageSender(this, requestMessage, callback);
        LOGGER.debug("Start MessageSender");
        sender.start();
    }

    @Override
    public EgovIntegrationMessage sendSync(EgovIntegrationMessage requestMessage) {
        LOGGER.debug("sendSync called without timeout");
        if (requestMessage == null) {
            LOGGER.error("requestMessage is null");
            throw new IllegalArgumentException();
        }
        LOGGER.debug("call sendSync with defauleTimeout");
        return this.sendSync(requestMessage, this.defaultTimeout);
    }

    @Override
    public EgovIntegrationMessage sendSync(EgovIntegrationMessage requestMessage, long timeout) {
        LOGGER.debug("sendSync called with timeout");
        if (requestMessage == null) {
            LOGGER.error("requestMessage is null");
            throw new IllegalArgumentException();
        }
        LOGGER.debug("Create MessageSender without Callback");
        MessageSender sender = new MessageSender(this, requestMessage, null);
        LOGGER.debug("Start MessageSender");
        sender.start();
        LOGGER.debug("Wait for the termination of MessageSender");
        try {
            sender.join(timeout);
        }
        catch (InterruptedException e) {
            LOGGER.debug("MessageSender was interrupted", (Throwable)e);
        }
        if (sender.isAlive()) {
            LOGGER.debug("MessageSender is alive over 'timeout'.");
            sender.interrupt();
            SimpleMessageHeader responseHeader = new SimpleMessageHeader(requestMessage.getHeader());
            responseHeader.setResultCode(EgovIntegrationMessageHeader.ResultCode.TIME_OUT);
            return new SimpleMessage(responseHeader);
        }
        LOGGER.debug("MessageSender finished to send and receive messages.");
        return sender.getResponseMessage();
    }

    protected abstract EgovIntegrationMessage doSend(EgovIntegrationMessage var1);
}

