/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.configuration.DuplicateJobException;
import org.springframework.batch.core.configuration.JobRegistry;
import org.springframework.batch.core.configuration.support.ApplicationContextFactory;
import org.springframework.batch.core.configuration.support.JobLoader;
import org.springframework.batch.core.configuration.support.ReferenceJobFactory;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.context.ConfigurableApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJobLoader
implements JobLoader {
    private static Log logger = LogFactory.getLog(DefaultJobLoader.class);
    private JobRegistry jobRegistry;
    private Map<ApplicationContextFactory, ConfigurableApplicationContext> contexts = new ConcurrentHashMap<ApplicationContextFactory, ConfigurableApplicationContext>();
    private Map<ConfigurableApplicationContext, Collection<String>> contextToJobNames = new ConcurrentHashMap<ConfigurableApplicationContext, Collection<String>>();

    public DefaultJobLoader() {
        this(null);
    }

    public DefaultJobLoader(JobRegistry jobRegistry) {
        this.jobRegistry = jobRegistry;
    }

    public void setJobRegistry(JobRegistry jobRegistry) {
        this.jobRegistry = jobRegistry;
    }

    @Override
    public void clear() {
        for (ConfigurableApplicationContext context : this.contexts.values()) {
            if (!context.isActive()) continue;
            context.close();
        }
        for (String jobName : this.jobRegistry.getJobNames()) {
            this.jobRegistry.unregister(jobName);
        }
        this.contexts.clear();
    }

    @Override
    public Collection<Job> reload(ApplicationContextFactory factory) {
        if (this.contexts.containsKey(factory)) {
            ConfigurableApplicationContext context = this.contexts.get(factory);
            for (String name : this.contextToJobNames.get(context)) {
                logger.debug((Object)("Unregistering job: " + name + " from context: " + context.getDisplayName()));
                this.jobRegistry.unregister(name);
            }
            context.close();
        }
        try {
            return this.doLoad(factory, true);
        }
        catch (DuplicateJobException e) {
            throw new IllegalStateException("Found duplicte job in reload (it should have been unregistered if it was previously registered in this loader)", e);
        }
    }

    @Override
    public Collection<Job> load(ApplicationContextFactory factory) throws DuplicateJobException {
        return this.doLoad(factory, false);
    }

    private Collection<Job> doLoad(ApplicationContextFactory factory, boolean unregister) throws DuplicateJobException {
        String[] names;
        Collection<String> jobNamesBefore = this.jobRegistry.getJobNames();
        ConfigurableApplicationContext context = factory.createApplicationContext();
        Collection<String> jobNamesAfter = this.jobRegistry.getJobNames();
        boolean autoRegistrationDetected = jobNamesAfter.size() > jobNamesBefore.size();
        HashSet<String> jobsRegistered = new HashSet<String>();
        if (autoRegistrationDetected) {
            for (String name : jobNamesAfter) {
                if (jobNamesBefore.contains(name)) continue;
                jobsRegistered.add(name);
            }
        }
        this.contexts.put(factory, context);
        for (String name : names = context.getBeanNamesForType(Job.class)) {
            if (autoRegistrationDetected) continue;
            Job job = (Job)context.getBean(name);
            String jobName = job.getName();
            if (unregister) {
                logger.debug((Object)("Unregistering job: " + jobName + " from context: " + context.getDisplayName()));
                this.jobRegistry.unregister(jobName);
            }
            logger.debug((Object)("Registering job: " + jobName + " from context: " + context.getDisplayName()));
            ReferenceJobFactory jobFactory = new ReferenceJobFactory(job);
            this.jobRegistry.register(jobFactory);
            jobsRegistered.add(jobName);
        }
        ArrayList<Job> result = new ArrayList<Job>();
        for (String name : jobsRegistered) {
            try {
                result.add(this.jobRegistry.getJob(name));
            }
            catch (NoSuchJobException e) {
                throw new IllegalStateException("Could not retrieve job that was should have been registered", e);
            }
        }
        this.contextToJobNames.put(context, jobsRegistered);
        return result;
    }
}

