/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.job;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.JobParametersValidator;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class DefaultJobParametersValidator
implements JobParametersValidator,
InitializingBean {
    private Collection<String> requiredKeys;
    private Collection<String> optionalKeys;

    public DefaultJobParametersValidator() {
        this(new String[0], new String[0]);
    }

    public DefaultJobParametersValidator(String[] requiredKeys, String[] optionalKeys) {
        this.setRequiredKeys(requiredKeys);
        this.setOptionalKeys(optionalKeys);
    }

    public void afterPropertiesSet() throws IllegalStateException {
        for (String key : this.requiredKeys) {
            Assert.state((!this.optionalKeys.contains(key) ? 1 : 0) != 0, (String)("Optional keys canot be required: " + key));
        }
    }

    public void validate(JobParameters parameters) throws JobParametersInvalidException {
        HashSet<String> missingKeys;
        if (parameters == null) {
            throw new JobParametersInvalidException("The JobParameters can not be null");
        }
        Set<String> keys = parameters.getParameters().keySet();
        if (!this.optionalKeys.isEmpty()) {
            missingKeys = new HashSet<String>();
            for (String key : keys) {
                if (this.optionalKeys.contains(key) || this.requiredKeys.contains(key)) continue;
                missingKeys.add(key);
            }
            if (!missingKeys.isEmpty()) {
                throw new JobParametersInvalidException("The JobParameters contains keys that are not explicitly optional or required: " + missingKeys);
            }
        }
        missingKeys = new HashSet();
        for (String key : this.requiredKeys) {
            if (keys.contains(key)) continue;
            missingKeys.add(key);
        }
        if (!missingKeys.isEmpty()) {
            throw new JobParametersInvalidException("The JobParameters do not contain required keys: " + missingKeys);
        }
    }

    public final void setRequiredKeys(String[] requiredKeys) {
        this.requiredKeys = new HashSet<String>(Arrays.asList(requiredKeys));
    }

    public final void setOptionalKeys(String[] optionalKeys) {
        this.optionalKeys = new HashSet<String>(Arrays.asList(optionalKeys));
    }
}

