/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository.dao;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.json.JettisonMappedXmlDriver;
import java.util.Map;
import org.springframework.batch.core.repository.dao.ExecutionContextStringSerializer;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XStreamExecutionContextStringSerializer
implements ExecutionContextStringSerializer,
InitializingBean {
    private ReflectionProvider reflectionProvider = null;
    private HierarchicalStreamDriver hierarchicalStreamDriver;
    private XStream xstream;

    @Override
    public String serialize(Map<String, Object> context) {
        return this.xstream.toXML(context);
    }

    @Override
    public Map<String, Object> deserialize(String context) {
        return (Map)this.xstream.fromXML(context);
    }

    public void setReflectionProvider(ReflectionProvider reflectionProvider) {
        this.reflectionProvider = reflectionProvider;
    }

    public void setHierarchicalStreamDriver(HierarchicalStreamDriver hierarchicalStreamDriver) {
        this.hierarchicalStreamDriver = hierarchicalStreamDriver;
    }

    public void afterPropertiesSet() throws Exception {
        this.init();
    }

    public synchronized void init() throws Exception {
        if (this.hierarchicalStreamDriver == null) {
            this.hierarchicalStreamDriver = new JettisonMappedXmlDriver();
        }
        this.xstream = this.reflectionProvider == null ? new XStream(this.hierarchicalStreamDriver) : new XStream(this.reflectionProvider, this.hierarchicalStreamDriver);
    }
}

