/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.bat.core.item.composite.reader;

import egovframework.rte.bat.core.item.composite.EgovItemsMapper;
import java.util.Iterator;
import java.util.List;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.ItemStreamReader;
import org.springframework.batch.item.NonTransientResourceException;
import org.springframework.batch.item.ParseException;
import org.springframework.batch.item.UnexpectedInputException;
import org.springframework.batch.item.database.AbstractCursorItemReader;

public class EgovCompositeCursorReader<T>
implements ItemStreamReader<T> {
    private List<AbstractCursorItemReader<?>> itemReaderList;
    private EgovItemsMapper<T> itemsMapper;
    private String returnType;

    public T read() throws Exception, UnexpectedInputException, ParseException, NonTransientResourceException {
        Object[] items = new Object[this.itemReaderList.size()];
        int count = 0;
        int flagCount = 0;
        if (this.returnType.toUpperCase().equals("READER")) {
            Iterator<AbstractCursorItemReader<?>> i$ = this.itemReaderList.iterator();
            while (i$.hasNext()) {
                AbstractCursorItemReader<?> itemReader;
                items[count] = itemReader = i$.next();
                ++count;
            }
        } else {
            for (AbstractCursorItemReader<?> itemReader : this.itemReaderList) {
                Object o = null;
                o = itemReader.read();
                if (o == null) {
                    ++flagCount;
                } else {
                    items[count] = o;
                }
                ++count;
                if (flagCount != this.itemReaderList.size()) continue;
                return null;
            }
        }
        return this.itemsMapper.mapItems(items);
    }

    public void update(ExecutionContext executionContext) {
        for (AbstractCursorItemReader<?> itemStream : this.itemReaderList) {
            itemStream.update(executionContext);
        }
    }

    public void close() throws ItemStreamException {
        for (AbstractCursorItemReader<?> itemStream : this.itemReaderList) {
            itemStream.close();
        }
    }

    public void open(ExecutionContext executionContext) throws ItemStreamException {
        for (AbstractCursorItemReader<?> itemStream : this.itemReaderList) {
            itemStream.open(executionContext);
        }
    }

    public void setItemsMapper(EgovItemsMapper<T> mapper) {
        this.itemsMapper = mapper;
    }

    public void setItemReaderList(List<AbstractCursorItemReader<?>> itemReaderList) {
        this.itemReaderList = itemReaderList;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }
}

