/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.bat.core.launch.support;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobExecutionNotRunningException;
import org.springframework.batch.core.launch.JobInstanceAlreadyExistsException;
import org.springframework.batch.core.launch.JobOperator;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.batch.core.launch.NoSuchJobExecutionException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.util.Assert;

public class EgovBatchRunner {
    private JobOperator jobOperator;
    private JobExplorer jobExplorer;
    private JobRepository jobRepository;

    public EgovBatchRunner(JobOperator jobOperator, JobExplorer jobExplorer, JobRepository jobRepository) {
        Assert.notNull((Object)jobOperator, (String)"The JobOperator is mandatory");
        Assert.notNull((Object)jobExplorer, (String)"The JobExplorer is mandatory");
        Assert.notNull((Object)jobRepository, (String)"The JobRepository is mandatory");
        this.jobOperator = jobOperator;
        this.jobExplorer = jobExplorer;
        this.jobRepository = jobRepository;
    }

    public JobOperator getJobOperator() {
        return this.jobOperator;
    }

    public JobExplorer getJobExplorer() {
        return this.jobExplorer;
    }

    public JobRepository getJobRepository() {
        return this.jobRepository;
    }

    public Long start(String jobName, String jobParameters) throws NoSuchJobException, JobParametersInvalidException, JobInstanceAlreadyExistsException {
        return this.jobOperator.start(jobName, jobParameters);
    }

    public Long restart(Long jobExecutionId) throws JobInstanceAlreadyCompleteException, NoSuchJobExecutionException, NoSuchJobException, JobRestartException, JobParametersInvalidException {
        return this.jobOperator.restart(jobExecutionId.longValue());
    }

    public void stop(Long jobExecutionId) throws NoSuchJobExecutionException, JobExecutionNotRunningException {
        this.jobOperator.stop(jobExecutionId.longValue());
    }

    public String createUniqueJobParameters() {
        HashMap<String, JobParameter> parameters = new HashMap<String, JobParameter>();
        parameters.put("timestamp", new JobParameter(Long.valueOf(new Date().getTime())));
        return this.convertJobParametersToString(new JobParameters(parameters));
    }

    public String addJobParameter(String jobParameters, String parameterName, String parameterValue) {
        String delim = "";
        if (!"".equals(jobParameters)) {
            delim = ",";
        }
        return jobParameters.concat(delim).concat(parameterName).concat("=").concat(parameterValue);
    }

    public String convertJobParametersToString(JobParameters jobParamters) {
        String convertedJobParameters = jobParamters.toString();
        if (convertedJobParameters.startsWith("{")) {
            convertedJobParameters = convertedJobParameters.substring(1);
        }
        if (convertedJobParameters.endsWith("}")) {
            convertedJobParameters = convertedJobParameters.substring(0, convertedJobParameters.length() - 1);
        }
        return convertedJobParameters;
    }

    public Set<String> getJobNames() {
        return this.jobOperator.getJobNames();
    }

    public JobExecution getJobExecution(Long jobExecutionId) {
        return this.jobExplorer.getJobExecution(jobExecutionId);
    }

    public List<JobExecution> getJobExecutions(Long jobExecutionId) {
        return this.jobExplorer.getJobExecutions(this.getJobInstance(jobExecutionId));
    }

    public JobExecution getLastJobExecution(String jobName, JobParameters jobParameters) {
        return this.jobRepository.getLastJobExecution(jobName, jobParameters);
    }

    public StepExecution getLastStepExecution(Long jobExecutionId, String stepName) {
        return this.jobRepository.getLastStepExecution(this.getJobInstance(jobExecutionId), stepName);
    }

    public JobInstance getJobInstance(Long jobExecutionId) {
        return this.getJobExecution(jobExecutionId).getJobInstance();
    }
}

