/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.bat.core.launch.support;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class EgovSchedulerRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(EgovSchedulerRunner.class);
    private String contextPath;
    private String schedulerJobPath;
    private List<String> jobPaths;
    private long delayTime;

    public EgovSchedulerRunner(String contextPath, String schedulerJobPath, List<String> jobPaths, long delayTime) {
        this.contextPath = contextPath;
        this.schedulerJobPath = schedulerJobPath;
        this.jobPaths = jobPaths;
        this.delayTime = delayTime;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public void setSchedulerJobPath(String schedulerJobPath) {
        this.schedulerJobPath = schedulerJobPath;
    }

    public void setJobPath(List<String> jobPaths) {
        this.jobPaths = jobPaths;
    }

    public void setDelayTime(long delayTime) {
        this.delayTime = delayTime;
    }

    public void start() {
        ArrayList<String> paths = new ArrayList<String>();
        paths.add(this.contextPath);
        paths.add(this.schedulerJobPath);
        for (int index = 0; index < this.jobPaths.size(); ++index) {
            paths.add(this.jobPaths.get(index));
        }
        String[] locations = paths.toArray(new String[paths.size()]);
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(locations, false);
        context.refresh();
        LOGGER.warn("ApplicationContext Running Time: {} seconds ", (Object)(this.delayTime / 1000L));
        boolean mustContinue = false;
        long realDelayTIme = this.delayTime;
        if (this.delayTime < 0L) {
            mustContinue = true;
            realDelayTIme = -1L * this.delayTime;
        }
        if (mustContinue) {
            LOGGER.info("Continue...");
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    Thread.sleep(realDelayTIme);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                    break;
                }
            }
            LOGGER.info("Sleeping ends...");
            context.close();
        } else {
            try {
                LOGGER.info("Sleeping Time: {} sedonds ", (Object)(realDelayTIme / 1000L));
                Thread.sleep(realDelayTIme);
                LOGGER.info("Sleeping ends...");
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            context.close();
        }
    }
}

