/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.types;

import org.exolab.castor.builder.types.AbstractDigitsFacet;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public final class XSByte
extends AbstractDigitsFacet {
    public static final String NAME = "byte";
    public static final short TYPE = 38;
    public static final String MIN_VALUE = Byte.toString((byte)-128);
    public static final String MAX_VALUE = Byte.toString((byte)127);
    private final boolean _asWrapper;
    private final JType _jType;

    public XSByte() {
        this(false);
    }

    public XSByte(boolean asWrapper) {
        this._asWrapper = asWrapper;
        this._jType = this._asWrapper ? new JClass("java.lang.Byte") : JType.BYTE;
    }

    public String getName() {
        return NAME;
    }

    public short getType() {
        return 38;
    }

    public boolean isPrimitive() {
        return true;
    }

    public boolean isDateTime() {
        return false;
    }

    public JType getJType() {
        return this._jType;
    }

    public String newInstanceCode() {
        return "new java.lang.Byte((byte) 0);";
    }

    public String createDefaultValueWithString(String variableName) {
        if (this._asWrapper) {
            return "new java.lang.Byte(" + variableName + ")";
        }
        return "new java.lang.Byte(" + variableName + ").byteValue()";
    }

    public String createToJavaObjectCode(String variableName) {
        if (this._asWrapper) {
            return variableName;
        }
        return "new java.lang.Byte(" + variableName + ")";
    }

    public String createFromJavaObjectCode(String variableName) {
        if (this._asWrapper) {
            return "((java.lang.Byte) " + variableName + ")";
        }
        return "((java.lang.Byte) " + variableName + ").byteValue()";
    }

    public void validationCode(JSourceCode jsc, String fixedValue, String validatorInstanceName) {
        jsc.add("org.exolab.castor.xml.validators.ByteValidator typeValidator;\ntypeValidator = new org.exolab.castor.xml.validators.ByteValidator();\n{0}.setValidator(typeValidator);", validatorInstanceName);
        if (fixedValue != null) {
            jsc.add("typeValidator.setFixed((byte) " + fixedValue + ");");
        }
        this.codePatternFacet(jsc, "typeValidator");
        this.codeWhiteSpaceFacet(jsc, "typeValidator");
        if (this.getMinExclusive() != null) {
            jsc.add("typeValidator.setMinExclusive((byte) " + this.getMinExclusive() + ");");
        } else if (this.getMinInclusive() != null) {
            jsc.add("typeValidator.setMinInclusive((byte) " + this.getMinInclusive() + ");");
        }
        if (this.getMaxExclusive() != null) {
            jsc.add("typeValidator.setMaxExclusive((byte) " + this.getMaxExclusive() + ");");
        } else if (this.getMaxInclusive() != null) {
            jsc.add("typeValidator.setMaxInclusive((byte) " + this.getMaxInclusive() + ");");
        }
        this.codeDigitsFacet(jsc, "typeValidator");
    }
}

