/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.itl.integration.support;

import egovframework.rte.itl.integration.EgovIntegrationMessage;
import egovframework.rte.itl.integration.EgovIntegrationServiceCallback;
import egovframework.rte.itl.integration.support.AbstractService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class MessageSender
extends Thread {
    private Log LOG = LogFactory.getLog(this.getClass());
    protected AbstractService service;
    protected EgovIntegrationMessage requestMessage;
    protected EgovIntegrationMessage responseMessage = null;
    protected EgovIntegrationServiceCallback callback = null;

    public MessageSender(AbstractService service, EgovIntegrationMessage requestMessage, EgovIntegrationServiceCallback callback) {
        this.service = service;
        this.requestMessage = requestMessage;
        this.callback = callback;
    }

    public EgovIntegrationMessage getResponseMessage() {
        return this.responseMessage;
    }

    public void run() {
        this.LOG.debug((Object)"MessageSender just Start");
        EgovIntegrationServiceCallback.CallbackId callbackId = null;
        if (this.callback != null) {
            callbackId = this.callback.createId(this.service, this.requestMessage);
            this.LOG.debug((Object)("Create CallbackId(" + callbackId + ")"));
        }
        this.LOG.debug((Object)"Send and Receive Messages");
        this.responseMessage = this.service.doSend(this.requestMessage);
        if (this.callback != null) {
            this.LOG.debug((Object)"Notify to callback");
            this.callback.onReceive(callbackId, this.responseMessage);
        }
    }
}

