/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import java.io.IOException;
import java.net.ConnectException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.ULogger;
import org.apache.log4j.net.PortBased;
import org.apache.log4j.net.SocketNode;
import org.apache.log4j.net.SocketNodeEventListener;
import org.apache.log4j.plugins.Plugin;
import org.apache.log4j.plugins.Receiver;
import org.apache.log4j.spi.ComponentBase;
import org.apache.log4j.spi.LoggerRepository;

public class SocketHubReceiver
extends Receiver
implements SocketNodeEventListener,
PortBased {
    static final int DEFAULT_RECONNECTION_DELAY = 30000;
    protected String host;
    protected int port;
    protected int reconnectionDelay = 30000;
    protected boolean active = false;
    protected Connector connector;
    protected Socket socket;
    private List listenerList = Collections.synchronizedList(new ArrayList());

    public SocketHubReceiver() {
    }

    public SocketHubReceiver(String _host, int _port) {
        this.host = _host;
        this.port = _port;
    }

    public SocketHubReceiver(String _host, int _port, LoggerRepository _repository) {
        this.host = _host;
        this.port = _port;
        this.repository = _repository;
    }

    public void addSocketNodeEventListener(SocketNodeEventListener l) {
        this.listenerList.add(l);
    }

    public void removeSocketNodeEventListener(SocketNodeEventListener l) {
        this.listenerList.remove(l);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(String _host) {
        this.host = _host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int _port) {
        this.port = _port;
    }

    public void setReconnectionDelay(int delay) {
        int oldValue = this.reconnectionDelay;
        this.reconnectionDelay = delay;
        this.firePropertyChange("reconnectionDelay", oldValue, this.reconnectionDelay);
    }

    public int getReconnectionDelay() {
        return this.reconnectionDelay;
    }

    public boolean isEquivalent(Plugin testPlugin) {
        if (testPlugin != null && testPlugin instanceof SocketHubReceiver) {
            SocketHubReceiver sReceiver = (SocketHubReceiver)testPlugin;
            return this.port == sReceiver.getPort() && this.host.equals(sReceiver.getHost()) && this.reconnectionDelay == sReceiver.getReconnectionDelay() && super.isEquivalent(testPlugin);
        }
        return false;
    }

    public synchronized boolean isActive() {
        return this.active;
    }

    protected synchronized void setActive(boolean _active) {
        this.active = _active;
    }

    public void activateOptions() {
        if (!this.isActive()) {
            this.setActive(true);
            this.fireConnector(false);
        }
    }

    public synchronized void shutdown() {
        this.active = false;
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.socket = null;
        if (this.connector != null) {
            this.connector.interrupted = true;
            this.connector = null;
        }
    }

    public void socketClosedEvent(Exception e) {
        this.connector = null;
        this.fireConnector(true);
    }

    private synchronized void fireConnector(boolean isReconnect) {
        if (this.active && this.connector == null) {
            this.getLogger().debug("Starting a new connector thread.");
            this.connector = new Connector(isReconnect);
            this.connector.setDaemon(true);
            this.connector.setPriority(1);
            this.connector.start();
        }
    }

    private synchronized void setSocket(Socket _socket) {
        this.connector = null;
        this.socket = _socket;
        SocketNode node = new SocketNode(this.socket, this);
        node.addSocketNodeEventListener(this);
        List list = this.listenerList;
        synchronized (list) {
            Iterator iter = this.listenerList.iterator();
            while (iter.hasNext()) {
                SocketNodeEventListener listener = (SocketNodeEventListener)iter.next();
                node.addSocketNodeEventListener(listener);
            }
        }
        new Thread(node).start();
    }

    public void socketOpened(String remoteInfo) {
    }

    static /* synthetic */ ULogger access$001(SocketHubReceiver x0) {
        return x0.getLogger();
    }

    static /* synthetic */ ULogger access$101(SocketHubReceiver x0) {
        return x0.getLogger();
    }

    static /* synthetic */ ULogger access$301(SocketHubReceiver x0) {
        return x0.getLogger();
    }

    static /* synthetic */ ULogger access$401(SocketHubReceiver x0) {
        return x0.getLogger();
    }

    static /* synthetic */ ULogger access$501(SocketHubReceiver x0) {
        return x0.getLogger();
    }

    static /* synthetic */ ULogger access$601(SocketHubReceiver x0) {
        return x0.getLogger();
    }

    class Connector
    extends Thread {
        boolean interrupted = false;
        boolean doDelay;

        public Connector(boolean isReconnect) {
            this.doDelay = isReconnect;
        }

        public void run() {
            while (!this.interrupted) {
                try {
                    if (this.doDelay) {
                        ComponentBase.access$001((SocketHubReceiver)SocketHubReceiver.this).debug("waiting for " + SocketHubReceiver.this.reconnectionDelay + " milliseconds before reconnecting.");
                        Thread.sleep(SocketHubReceiver.this.reconnectionDelay);
                    }
                    this.doDelay = true;
                    ComponentBase.access$101((SocketHubReceiver)SocketHubReceiver.this).debug("Attempting connection to " + SocketHubReceiver.this.host);
                    Socket socket = new Socket(SocketHubReceiver.this.host, SocketHubReceiver.this.port);
                    SocketHubReceiver.this.setSocket(socket);
                    ComponentBase.access$301((SocketHubReceiver)SocketHubReceiver.this).debug("Connection established. Exiting connector thread.");
                    break;
                }
                catch (InterruptedException e) {
                    ComponentBase.access$401((SocketHubReceiver)SocketHubReceiver.this).debug("Connector interrupted. Leaving loop.");
                    return;
                }
                catch (ConnectException e) {
                    ComponentBase.access$501((SocketHubReceiver)SocketHubReceiver.this).debug((Object)"Remote host {} refused connection.", SocketHubReceiver.this.host);
                }
                catch (IOException e) {
                    ComponentBase.access$601((SocketHubReceiver)SocketHubReceiver.this).debug("Could not connect to {}. Exception is {}.", SocketHubReceiver.this.host, e);
                }
            }
        }
    }
}

