/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.itl.integration.metadata;

import egovframework.rte.itl.integration.metadata.ServiceDefinition;
import egovframework.rte.itl.integration.metadata.SystemDefinition;
import egovframework.rte.itl.integration.util.Validatable;
import java.util.Calendar;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.util.StringUtils;

public class IntegrationDefinition
implements Validatable {
    private String id;
    private ServiceDefinition provider;
    private SystemDefinition consumer;
    private long defaultTimeout;
    private boolean using;
    private Calendar validateFrom;
    private Calendar validateTo;
    private boolean valid = false;
    private AtomicBoolean statusChanged = new AtomicBoolean(false);

    public IntegrationDefinition() {
    }

    public IntegrationDefinition(String id, ServiceDefinition provider, SystemDefinition consumer, long defaultTimeout, boolean using, Calendar validateFrom, Calendar validateTo) {
        this.id = id;
        this.provider = provider;
        this.consumer = consumer;
        this.defaultTimeout = defaultTimeout;
        this.using = using;
        this.validateFrom = validateFrom;
        this.validateTo = validateTo;
        this.statusChanged.set(true);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
        this.statusChanged.set(true);
    }

    public ServiceDefinition getProvider() {
        return this.provider;
    }

    public void setProvider(ServiceDefinition provider) {
        this.provider = provider;
        this.statusChanged.set(true);
    }

    public SystemDefinition getConsumer() {
        return this.consumer;
    }

    public void setConsumer(SystemDefinition consumer) {
        this.consumer = consumer;
        this.statusChanged.set(true);
    }

    public long getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public void setDefaultTimeout(long defaultTimeout) {
        this.defaultTimeout = defaultTimeout;
    }

    public boolean isUsing() {
        return this.using;
    }

    public void setUsing(boolean using) {
        this.using = using;
    }

    public Calendar getValidateFrom() {
        return this.validateFrom;
    }

    public void setValidateFrom(Calendar validateFrom) {
        this.validateFrom = validateFrom;
    }

    public Calendar getValidateTo() {
        return this.validateTo;
    }

    public void setValidateTo(Calendar validateTo) {
        this.validateTo = validateTo;
    }

    public boolean isValid() {
        if (this.statusChanged.getAndSet(false)) {
            boolean bl = this.valid = StringUtils.hasText((String)this.id) && this.provider != null && this.consumer != null;
            if (this.provider != null) {
                boolean bl2 = this.valid = this.valid && this.provider.isValid();
            }
            if (this.consumer != null) {
                this.valid = this.valid && this.consumer.isValid();
            }
        }
        return this.valid;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append(" {").append("\n\tid = ").append(StringUtils.quote((String)this.id)).append("\n\tprovider = ").append(this.provider == null ? "" : "\n").append(this.provider).append("\n\tconsumer = ").append(this.consumer == null ? "" : "\n").append(this.consumer).append("\n\tdefaultTimeout = ").append(this.defaultTimeout).append("\n\tusing = ").append(this.using).append("\n\tvalidateFrom = ").append(this.validateFrom).append("\n\tvalidateTo = ").append(this.validateTo).append("\n}");
        return sb.toString();
    }
}

