/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.fdl.security.config.internal;

import egovframework.rte.fdl.logging.util.EgovJdkLogger;
import egovframework.rte.fdl.security.config.SecurityConfig;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.StringUtils;

public class AuthoritiesQueryFactoryBean
implements FactoryBean<String>,
ApplicationContextAware {
    private ApplicationContext context;
    private String defaultQuery;

    public String getObject() throws Exception {
        try {
            SecurityConfig config = (SecurityConfig)this.context.getBean(SecurityConfig.class);
            if (StringUtils.hasText((String)config.getJdbcAuthoritiesByUsernameQuery())) {
                return config.getJdbcAuthoritiesByUsernameQuery();
            }
        }
        catch (NoSuchBeanDefinitionException nsbde) {
            EgovJdkLogger.ignore((String)"There is no SecurityConfig.class.");
        }
        return this.defaultQuery;
    }

    public Class<String> getObjectType() {
        return String.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    public String getDefaultQuery() {
        return this.defaultQuery;
    }

    @Required
    public void setDefaultQuery(String defaultQuery) {
        this.defaultQuery = defaultQuery;
    }
}

