/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.fdl.idgnr.impl;

import egovframework.rte.fdl.cmmn.exception.FdlException;
import egovframework.rte.fdl.idgnr.impl.AbstractDataBlockIdGnrService;
import java.math.BigDecimal;
import java.util.Locale;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;

public class EgovTableIdGnrService
extends AbstractDataBlockIdGnrService {
    private String table = "ids";
    private String tableName = "id";
    private String tableNameFieldName = "table_name";
    private String nextIdFieldName = "next_id";
    private JdbcTemplate jdbcTemplate;

    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    private Object insertInitId(boolean useBigDecimals, int blockSize) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)this.messageSource.getMessage("debug.idgnr.init.idblock", new Object[]{this.tableName}, Locale.getDefault()));
        }
        Number initId = null;
        String insertQuery = "INSERT INTO " + this.table + "(" + this.tableNameFieldName + ", " + this.nextIdFieldName + ") " + "values('" + this.tableName + "', ?)";
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Insert Query : " + insertQuery));
        }
        initId = useBigDecimals ? new BigDecimal(blockSize) : new Long(blockSize);
        this.jdbcTemplate.update(insertQuery, new Object[]{initId});
        return initId;
    }

    private Object allocateIdBlock(int blockSize, boolean useBigDecimals) throws FdlException {
        Object nextId;
        block15: {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)this.messageSource.getMessage("debug.idgnr.allocate.idblock", new Object[]{new Integer(blockSize), this.tableName}, Locale.getDefault()));
            }
            try {
                String selectQuery = "SELECT " + this.nextIdFieldName + " FROM " + this.table + " WHERE " + this.tableNameFieldName + " = ?";
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("Select Query : " + selectQuery));
                }
                if (useBigDecimals) {
                    try {
                        nextId = this.jdbcTemplate.queryForObject(selectQuery, new Object[]{this.tableName}, BigDecimal.class);
                    }
                    catch (EmptyResultDataAccessException erdae) {
                        nextId = null;
                    }
                    if (nextId == null) {
                        this.insertInitId(useBigDecimals, blockSize);
                        return new BigDecimal(0);
                    }
                    break block15;
                }
                try {
                    nextId = this.jdbcTemplate.queryForLong(selectQuery, new Object[]{this.tableName});
                }
                catch (EmptyResultDataAccessException erdae) {
                    nextId = -1L;
                }
                if ((Long)nextId == -1L) {
                    this.insertInitId(useBigDecimals, blockSize);
                    return new Long(0L);
                }
            }
            catch (DataAccessException dae) {
                dae.printStackTrace();
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)"", (Throwable)dae);
                }
                throw new FdlException(this.messageSource, "error.idgnr.select.idblock", (Object[])new String[]{this.tableName}, null);
            }
        }
        try {
            String updateQuery = "UPDATE " + this.table + " SET " + this.nextIdFieldName + " = ?" + " WHERE " + this.tableNameFieldName + " = ?";
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("Update Query : " + updateQuery));
            }
            Number newNextId = useBigDecimals ? ((BigDecimal)nextId).add(new BigDecimal(blockSize)) : new Long((Long)nextId + (long)blockSize);
            this.jdbcTemplate.update(updateQuery, new Object[]{newNextId, this.tableName});
            return nextId;
        }
        catch (DataAccessException dae) {
            throw new FdlException(this.messageSource, "error.idgnr.update.idblockk", (Object[])new String[]{this.tableName}, null);
        }
    }

    protected BigDecimal allocateBigDecimalIdBlock(int blockSize) throws FdlException {
        return (BigDecimal)this.allocateIdBlock(blockSize, true);
    }

    protected long allocateLongIdBlock(int blockSize) throws FdlException {
        Long id = (Long)this.allocateIdBlock(blockSize, false);
        return id;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setTableNameFieldName(String tableNameFieldName) {
        this.tableNameFieldName = tableNameFieldName;
    }

    public void setNextIdFieldName(String nextIdFieldName) {
        this.nextIdFieldName = nextIdFieldName;
    }
}

