/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.bat.core.item.file.transform;

import java.util.ArrayList;
import java.util.List;
import org.springframework.batch.item.file.transform.ExtractorLineAggregator;
import org.springframework.util.Assert;

public class EgovFixedLengthLineAggregator<T>
extends ExtractorLineAggregator<T> {
    private int[] fieldRanges;
    private List<String> paddingList;
    private static final int PADDING_LISTSIZE = 100;
    private char padding = (char)32;

    public void setPadding(char padding) {
        this.padding = padding;
    }

    public void setFieldRanges(int[] fieldRanges) {
        this.fieldRanges = fieldRanges;
    }

    protected String doAggregate(Object[] fields) {
        if (this.paddingList == null) {
            this.createPaddingList();
        }
        Assert.notNull((Object)this.fieldRanges);
        return this.aggregateFixedLength(this.obtainFieldValueLength(fields), fields);
    }

    private String aggregateFixedLength(int[] fieldValueLength, Object[] fields) {
        int fieldsLength = fields.length;
        if (fieldsLength != this.fieldRanges.length) {
            Assert.state((fieldsLength == this.fieldRanges.length ? 1 : 0) != 0, (String)("The number of field's ranges: " + this.fieldRanges.length + " is must match the number of field: " + fieldsLength));
        }
        StringBuilder value = new StringBuilder();
        for (int k = 0; k < fieldsLength; ++k) {
            if (this.fieldRanges[k] >= fieldValueLength[k]) {
                value.append(fields[k].toString());
                if (this.fieldRanges[k] <= fieldValueLength[k]) continue;
                int needPaddingSize = this.fieldRanges[k] - fieldValueLength[k];
                if (needPaddingSize <= 100) {
                    value.append(this.paddingList.get(needPaddingSize - 1));
                    continue;
                }
                int addMaxPaddingCount = needPaddingSize / 100;
                int remainderPaddingSize = needPaddingSize % 100;
                for (int i = 0; i < addMaxPaddingCount; ++i) {
                    value.append(this.paddingList.get(99));
                }
                if (remainderPaddingSize == 0) continue;
                value.append(this.paddingList.get(remainderPaddingSize - 1));
                continue;
            }
            Assert.state((this.fieldRanges[k] >= fieldValueLength[k] ? 1 : 0) != 0, (String)("Supplied text: " + fields[k] + " is longer than defined length: " + this.fieldRanges[k]));
        }
        return value.toString();
    }

    private void createPaddingList() {
        this.paddingList = new ArrayList<String>(100);
        StringBuilder paddingBuilder = new StringBuilder();
        for (int i = 1; i <= 100; ++i) {
            paddingBuilder.append(this.padding);
            if (paddingBuilder.length() != i) continue;
            this.paddingList.add(paddingBuilder.toString());
        }
    }

    private int[] obtainFieldValueLength(Object[] fields) {
        int[] fieldValueLength = new int[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            fieldValueLength[i] = fields[i].toString().length();
        }
        return fieldValueLength;
    }
}

