/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.format.formatters;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.springframework.binding.format.Formatter;
import org.springframework.binding.format.InvalidFormatException;
import org.springframework.util.StringUtils;

public class DateFormatter
implements Formatter {
    public static final String DEFAULT_PATTERN = "yyyy-MM-dd";
    private String pattern;
    private Locale locale;

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public String format(Object date) {
        if (date == null) {
            return "";
        }
        return this.getDateFormat().format((Date)date);
    }

    public Object parse(String formattedString) throws InvalidFormatException {
        if (!StringUtils.hasText((String)formattedString)) {
            return null;
        }
        DateFormat dateFormat = this.getDateFormat();
        try {
            return dateFormat.parse(formattedString);
        }
        catch (ParseException parseException) {
            throw new InvalidFormatException(formattedString, dateFormat.toString());
        }
    }

    protected DateFormat getDateFormat() {
        if (this.pattern != null) {
            if (this.locale != null) {
                return new SimpleDateFormat(this.pattern, this.locale);
            }
            return new SimpleDateFormat(this.pattern);
        }
        if (this.locale != null) {
            return new SimpleDateFormat(DEFAULT_PATTERN, this.locale);
        }
        return new SimpleDateFormat(DEFAULT_PATTERN);
    }
}

