/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.mapping.impl;

import org.springframework.binding.convert.ConversionException;
import org.springframework.binding.convert.ConversionExecutor;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.expression.EvaluationException;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.mapping.Mapping;
import org.springframework.binding.mapping.impl.DefaultMappingContext;
import org.springframework.util.Assert;

public class DefaultMapping
implements Mapping {
    private final Expression sourceExpression;
    private final Expression targetExpression;
    private boolean required;
    private ConversionExecutor typeConverter;

    public DefaultMapping(Expression sourceExpression, Expression targetExpression) {
        Assert.notNull((Object)sourceExpression, (String)"The source expression is required");
        Assert.notNull((Object)targetExpression, (String)"The target expression is required");
        this.sourceExpression = sourceExpression;
        this.targetExpression = targetExpression;
    }

    public Expression getSourceExpression() {
        return this.sourceExpression;
    }

    public Expression getTargetExpression() {
        return this.targetExpression;
    }

    public boolean isRequired() {
        return this.required;
    }

    public ConversionExecutor getTypeConverter() {
        return this.typeConverter;
    }

    public void setTypeConverter(ConversionExecutor typeConverter) {
        this.typeConverter = typeConverter;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    void map(DefaultMappingContext context) {
        Object sourceValue;
        context.setCurrentMapping(this);
        try {
            sourceValue = this.sourceExpression.getValue(context.getSource());
        }
        catch (EvaluationException e) {
            context.setSourceAccessError(e);
            return;
        }
        if (this.required && (sourceValue == null || this.isEmptyString(sourceValue))) {
            context.setRequiredErrorResult(sourceValue);
            return;
        }
        Object targetValue = sourceValue;
        if (sourceValue != null) {
            if (this.typeConverter != null) {
                try {
                    targetValue = this.typeConverter.execute(targetValue, context);
                }
                catch (ConversionException e) {
                    context.setTypeConversionErrorResult(sourceValue, e.getTargetClass());
                    return;
                }
            }
            ConversionService conversionService = context.getConversionService();
            if (conversionService != null) {
                Class targetType;
                try {
                    targetType = this.targetExpression.getValueType(context.getTarget());
                }
                catch (EvaluationException e) {
                    context.setTargetAccessError(sourceValue, e);
                    return;
                }
                if (targetType != null && !targetType.isInstance(targetValue)) {
                    try {
                        ConversionExecutor typeConverter = conversionService.getConversionExecutor(sourceValue.getClass(), targetType);
                        targetValue = typeConverter.execute(sourceValue, context);
                    }
                    catch (ConversionException e) {
                        context.setTypeConversionErrorResult(sourceValue, e.getTargetClass());
                        return;
                    }
                }
            }
        }
        try {
            this.targetExpression.setValue(context.getTarget(), targetValue);
            context.setSuccessResult(sourceValue, targetValue);
        }
        catch (EvaluationException e) {
            context.setTargetAccessError(sourceValue, e);
        }
    }

    private boolean isEmptyString(Object sourceValue) {
        if (sourceValue instanceof CharSequence) {
            return ((CharSequence)sourceValue).length() == 0;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DefaultMapping)) {
            return false;
        }
        DefaultMapping other = (DefaultMapping)o;
        return this.sourceExpression.equals(other.sourceExpression) && this.targetExpression.equals(other.targetExpression);
    }

    public int hashCode() {
        return this.sourceExpression.hashCode() + this.targetExpression.hashCode();
    }

    public String toString() {
        return this.sourceExpression + " -> " + this.targetExpression;
    }
}

