/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.listener;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Advisor;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.batch.core.listener.ListenerMetaData;
import org.springframework.batch.core.listener.MethodInvokerMethodInterceptor;
import org.springframework.batch.support.MethodInvoker;
import org.springframework.batch.support.MethodInvokerUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractListenerFactoryBean
implements FactoryBean,
InitializingBean {
    private Object delegate;
    private Map<String, String> metaDataMap;

    public Object getObject() {
        if (this.metaDataMap == null) {
            this.metaDataMap = new HashMap<String, String>();
        }
        for (ListenerMetaData metaData : this.getMetaDataValues()) {
            if (this.metaDataMap.containsKey(metaData.getPropertyName())) continue;
            this.metaDataMap.put(metaData.getPropertyName(), null);
        }
        HashSet listenerInterfaces = new HashSet();
        HashMap<String, Set<MethodInvoker>> invokerMap = new HashMap<String, Set<MethodInvoker>>();
        boolean synthetic = false;
        for (Map.Entry<String, String> entry : this.metaDataMap.entrySet()) {
            ListenerMetaData listenerMetaData = this.getMetaDataFromPropertyName(entry.getKey());
            HashSet<MethodInvoker> invokers = new HashSet<MethodInvoker>();
            MethodInvoker invoker = MethodInvokerUtils.getMethodInvokerForInterface(listenerMetaData.getListenerInterface(), (String)listenerMetaData.getMethodName(), (Object)this.delegate, (Class[])listenerMetaData.getParamTypes());
            if (invoker != null) {
                invokers.add(invoker);
            }
            if ((invoker = this.getMethodInvokerByName(entry.getValue(), this.delegate, listenerMetaData.getParamTypes())) != null) {
                invokers.add(invoker);
                synthetic = true;
            }
            if ((invoker = MethodInvokerUtils.getMethodInvokerByAnnotation(listenerMetaData.getAnnotation(), (Object)this.delegate, (Class[])listenerMetaData.getParamTypes())) != null) {
                invokers.add(invoker);
                synthetic = true;
            }
            if (invokers.isEmpty()) continue;
            invokerMap.put(listenerMetaData.getMethodName(), invokers);
            listenerInterfaces.add(listenerMetaData.getListenerInterface());
        }
        if (listenerInterfaces.isEmpty()) {
            listenerInterfaces.add(this.getDefaultListenerClass());
        }
        if (!synthetic) {
            int count = 0;
            for (Class clazz : listenerInterfaces) {
                if (!clazz.isInstance(this.delegate)) continue;
                ++count;
            }
            if (count == listenerInterfaces.size()) {
                return this.delegate;
            }
        }
        boolean ordered = false;
        if (this.delegate instanceof Ordered) {
            ordered = true;
            listenerInterfaces.add(Ordered.class);
        }
        ProxyFactory proxyFactory = new ProxyFactory();
        if (this.delegate instanceof Advised) {
            proxyFactory.setTargetSource(((Advised)this.delegate).getTargetSource());
        } else {
            proxyFactory.setTarget(this.delegate);
        }
        proxyFactory.setInterfaces(listenerInterfaces.toArray(new Class[0]));
        proxyFactory.addAdvisor((Advisor)new DefaultPointcutAdvisor((Advice)new MethodInvokerMethodInterceptor(invokerMap, ordered)));
        return proxyFactory.getProxy();
    }

    protected abstract ListenerMetaData getMetaDataFromPropertyName(String var1);

    protected abstract ListenerMetaData[] getMetaDataValues();

    protected abstract Class<?> getDefaultListenerClass();

    protected MethodInvoker getMethodInvokerByName(String methodName, Object candidate, Class<?> ... params) {
        if (methodName != null) {
            return MethodInvokerUtils.getMethodInvokerByName((Object)candidate, (String)methodName, (boolean)false, (Class[])params);
        }
        return null;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setDelegate(Object delegate) {
        this.delegate = delegate;
    }

    public void setMetaDataMap(Map<String, String> metaDataMap) {
        this.metaDataMap = metaDataMap;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.delegate, (String)"Delegate must not be null");
    }

    public static boolean isListener(Object target, Class<?> listenerType, ListenerMetaData[] metaDataValues) {
        TargetSource targetSource;
        if (target == null) {
            return false;
        }
        if (listenerType.isInstance(target)) {
            return true;
        }
        if (target instanceof Advised && (targetSource = ((Advised)target).getTargetSource()) != null && targetSource.getTargetClass() != null && listenerType.isAssignableFrom(targetSource.getTargetClass())) {
            return true;
        }
        for (ListenerMetaData metaData : metaDataValues) {
            if (MethodInvokerUtils.getMethodInvokerByAnnotation(metaData.getAnnotation(), (Object)target) == null) continue;
            return true;
        }
        return false;
    }
}

