/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.tasklet;

import java.io.File;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.JobInterruptedException;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.listener.StepExecutionListenerSupport;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.SimpleSystemProcessExitCodeMapper;
import org.springframework.batch.core.step.tasklet.SystemCommandException;
import org.springframework.batch.core.step.tasklet.SystemProcessExitCodeMapper;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.util.Assert;

public class SystemCommandTasklet
extends StepExecutionListenerSupport
implements Tasklet,
InitializingBean {
    protected static final Log logger = LogFactory.getLog(SystemCommandTasklet.class);
    private String command;
    private String[] environmentParams = null;
    private File workingDirectory = null;
    private SystemProcessExitCodeMapper systemProcessExitCodeMapper = new SimpleSystemProcessExitCodeMapper();
    private long timeout = 0L;
    private long checkInterval = 1000L;
    private StepExecution execution = null;
    private TaskExecutor taskExecutor = new SimpleAsyncTaskExecutor();
    private boolean interruptOnCancel = false;

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        FutureTask<Integer> systemCommandTask = new FutureTask<Integer>(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                Process process = Runtime.getRuntime().exec(SystemCommandTasklet.this.command, SystemCommandTasklet.this.environmentParams, SystemCommandTasklet.this.workingDirectory);
                return process.waitFor();
            }
        });
        long t0 = System.currentTimeMillis();
        this.taskExecutor.execute(systemCommandTask);
        do {
            Thread.sleep(this.checkInterval);
            if (systemCommandTask.isDone()) {
                contribution.setExitStatus(this.systemProcessExitCodeMapper.getExitStatus(systemCommandTask.get()));
                return RepeatStatus.FINISHED;
            }
            if (System.currentTimeMillis() - t0 <= this.timeout) continue;
            systemCommandTask.cancel(this.interruptOnCancel);
            throw new SystemCommandException("Execution of system command did not finish within the timeout");
        } while (!this.execution.isTerminateOnly());
        systemCommandTask.cancel(this.interruptOnCancel);
        throw new JobInterruptedException("Job interrupted while executing system command '" + this.command + "'");
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public void setEnvironmentParams(String[] envp) {
        this.environmentParams = envp;
    }

    public void setWorkingDirectory(String dir) {
        if (dir == null) {
            this.workingDirectory = null;
            return;
        }
        this.workingDirectory = new File(dir);
        Assert.isTrue((boolean)this.workingDirectory.exists(), (String)"working directory must exist");
        Assert.isTrue((boolean)this.workingDirectory.isDirectory(), (String)"working directory value must be a directory");
    }

    public void afterPropertiesSet() throws Exception {
        Assert.hasLength((String)this.command, (String)"'command' property value is required");
        Assert.notNull((Object)this.systemProcessExitCodeMapper, (String)"SystemProcessExitCodeMapper must be set");
        Assert.isTrue((this.timeout > 0L ? 1 : 0) != 0, (String)"timeout value must be greater than zero");
        Assert.notNull((Object)this.taskExecutor, (String)"taskExecutor is required");
    }

    public void setSystemProcessExitCodeMapper(SystemProcessExitCodeMapper systemProcessExitCodeMapper) {
        this.systemProcessExitCodeMapper = systemProcessExitCodeMapper;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setTerminationCheckInterval(long checkInterval) {
        this.checkInterval = checkInterval;
    }

    public void beforeStep(StepExecution stepExecution) {
        this.execution = stepExecution;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void setInterruptOnCancel(boolean interruptOnCancel) {
        this.interruptOnCancel = interruptOnCancel;
    }
}

