/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.itl.webservice.service.impl;

import egovframework.rte.itl.integration.type.ListType;
import egovframework.rte.itl.integration.type.PrimitiveType;
import egovframework.rte.itl.integration.type.RecordType;
import egovframework.rte.itl.integration.type.Type;
import egovframework.rte.itl.webservice.EgovWebServiceMessageHeader;
import egovframework.rte.itl.webservice.service.EgovWebServiceClassLoader;
import egovframework.rte.itl.webservice.service.ServiceEndpointInfo;
import egovframework.rte.itl.webservice.service.ServiceEndpointInterfaceInfo;
import egovframework.rte.itl.webservice.service.ServiceParamInfo;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.jws.WebParam;
import javax.xml.ws.Holder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EgovWebServiceClassLoaderImpl
extends ClassLoader
implements EgovWebServiceClassLoader {
    private Log LOG = LogFactory.getLog(this.getClass());
    public static final String BASE_PACKAGE_NAME = "egovframework.rte.itl.webservice.generated";
    public static final String CLASS_NAME_PREFIX = "egovframework.rte.itl.webservice.generated.EgovType";
    public static final String SERVICE_ENDPOINT_CLASS_NAME_POSTFIX = "ServiceImpl";
    public static final String SERVICE_ENDPOINT_INTERFACE_CLASS_NAME_POSTFIX = "Service";
    public static final String NAME_OF_SERVICE_BRIDGE_CLASS = "egovframework/rte/itl/webservice/service/ServiceBridge";
    public static final String DESC_OF_SERVICE_BRIDGE_CLASS = "Legovframework/rte/itl/webservice/service/ServiceBridge;";
    public static final String FIELD_NAME_OF_SERVICE_BRIDGE = "serviceBridge";
    private static final Map<PrimitiveType, Class<?>> primitiveClasses = new HashMap<PrimitiveType, Class<?>>(){
        {
            this.put(PrimitiveType.BOOLEAN, Boolean.TYPE);
            this.put(PrimitiveType.STRING, String.class);
            this.put(PrimitiveType.BYTE, Byte.TYPE);
            this.put(PrimitiveType.SHORT, Short.TYPE);
            this.put(PrimitiveType.INTEGER, Integer.TYPE);
            this.put(PrimitiveType.LONG, Long.TYPE);
            this.put(PrimitiveType.BIGINTEGER, BigInteger.class);
            this.put(PrimitiveType.FLOAT, Float.TYPE);
            this.put(PrimitiveType.DOUBLE, Double.TYPE);
            this.put(PrimitiveType.BIGDECIMAL, BigDecimal.class);
            this.put(PrimitiveType.CALENDAR, Calendar.class);
        }
    };
    private static final Map<Class<?>, Class<?>> wrapperClasses = new HashMap<Class<?>, Class<?>>(){
        {
            this.put(Boolean.TYPE, Boolean.class);
            this.put(Byte.TYPE, Byte.class);
            this.put(Short.TYPE, Short.class);
            this.put(Integer.TYPE, Integer.class);
            this.put(Long.TYPE, Long.class);
            this.put(Float.TYPE, Float.class);
            this.put(Double.TYPE, Double.class);
        }
    };
    private static final String DESC_OF_XML_ACCESSOR_TYPE = "Ljavax/xml/bind/annotation/XmlAccessorType;";
    private static final String DESC_OF_XML_ACCESS_TYPE = "Ljavax/xml/bind/annotation/XmlAccessType;";
    private static final String DESC_OF_WEB_SERVICE = "Ljavax/jws/WebService;";
    private static final String DESC_OF_SOAP_BINDING = "Ljavax/jws/soap/SOAPBinding;";
    private static final String DESC_OF_SOAP_BINDING_PARAMETER_STYLE = "Ljavax/jws/soap/SOAPBinding$ParameterStyle;";
    private static final String DESC_OF_WEB_METHOD = "Ljavax/jws/WebMethod;";
    private static final String DESC_OF_WEB_PARAM = "Ljavax/jws/WebParam;";
    private static final String DESC_OF_WEB_PARAM_MODE = "Ljavax/jws/WebParam$Mode;";
    private static final String DESC_OF_WEB_RESULT = "Ljavax/jws/WebResult;";
    private static final org.objectweb.asm.Type TYPE_OF_HOLDER = org.objectweb.asm.Type.getType(Holder.class);

    protected EgovWebServiceClassLoaderImpl() {
    }

    protected EgovWebServiceClassLoaderImpl(ClassLoader parent) {
        super(parent);
    }

    @Override
    public String getFieldNameOfServiceBridge() {
        return FIELD_NAME_OF_SERVICE_BRIDGE;
    }

    @Override
    public Class<?> loadClass(Type type) throws ClassNotFoundException {
        this.LOG.debug((Object)("loadClass of Type (" + type + ")"));
        if (type == EgovWebServiceMessageHeader.TYPE) {
            this.LOG.debug((Object)"Type is EgovWebServiceMessageHeader.");
            return EgovWebServiceMessageHeader.class;
        }
        if (type instanceof PrimitiveType) {
            this.LOG.debug((Object)"Type is a Primitive Type");
            Class<?> clazz = primitiveClasses.get((PrimitiveType)type);
            if (clazz == null) {
                this.LOG.error((Object)"No such primitive type");
                throw new ClassNotFoundException();
            }
            return clazz;
        }
        if (type instanceof ListType) {
            this.LOG.debug((Object)"Type is a List Type");
            ListType listType = (ListType)type;
            Class<?> elementClass = this.loadClass(listType.getElementType());
            return Array.newInstance(elementClass, 0).getClass();
        }
        if (type instanceof RecordType) {
            this.LOG.debug((Object)"Type is a Record Type");
            RecordType recordType = (RecordType)type;
            String className = EgovWebServiceClassLoaderImpl.getRecordTypeClassName(recordType.getName());
            try {
                this.LOG.debug((Object)("Check the class \"" + className + "\" is already loaded."));
                return this.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                this.LOG.debug((Object)("Create a new class \"" + className + "\""));
                byte[] byteCode = this.createRecordClass(className, recordType);
                return this.defineClass(className, byteCode, 0, byteCode.length);
            }
        }
        this.LOG.error((Object)"Type is invalid");
        throw new ClassNotFoundException();
    }

    @Override
    public Class<?> loadClass(ServiceEndpointInfo serviceEndpointInfo) throws ClassNotFoundException {
        this.LOG.debug((Object)("loadClass of ServiceEndpointInfo (" + serviceEndpointInfo + ")"));
        this.LOG.debug((Object)"load Interface Class");
        this.loadClass((ServiceEndpointInterfaceInfo)serviceEndpointInfo);
        String className = EgovWebServiceClassLoaderImpl.getServiceEndpointClassName(serviceEndpointInfo.getServiceName());
        try {
            this.LOG.debug((Object)("Check the class \"" + className + "\" is already loaded"));
            return this.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            this.LOG.debug((Object)("Create a new class \"" + className + "\""));
            byte[] byteCode = this.createServiceEndpointClass(serviceEndpointInfo);
            return this.defineClass(className, byteCode, 0, byteCode.length);
        }
    }

    @Override
    public Class<?> loadClass(ServiceEndpointInterfaceInfo serviceEndpointInterfaceInfo) throws ClassNotFoundException {
        this.LOG.debug((Object)("loadClass of ServiceEndpointInterfaceInfo (" + serviceEndpointInterfaceInfo + ")"));
        String className = EgovWebServiceClassLoaderImpl.getServiceEndpointInterfaceClassName(serviceEndpointInterfaceInfo.getServiceName());
        try {
            this.LOG.debug((Object)("Check the class \"" + className + "\" is already loaded."));
            return this.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            this.LOG.debug((Object)"Create new ServiceEndpointInterface class");
            ServiceParamInfo returnInfo = serviceEndpointInterfaceInfo.getReturnInfo();
            if (returnInfo != null) {
                this.LOG.debug((Object)("Load return type (" + returnInfo.getType() + ")"));
                this.loadClass(returnInfo.getType());
            }
            for (ServiceParamInfo info : serviceEndpointInterfaceInfo.getParamInfos()) {
                this.LOG.debug((Object)("Load param type (" + info.getType() + ")"));
                this.loadClass(info.getType());
            }
            this.LOG.debug((Object)("Create a new class \"" + className + "\""));
            byte[] byteCode = this.createServiceEndpointInterfaceClass(serviceEndpointInterfaceInfo);
            return this.defineClass(className, byteCode, 0, byteCode.length);
        }
    }

    private byte[] createRecordClass(String className, RecordType recordType) throws ClassNotFoundException {
        String asmClassName = className.replace('.', '/');
        ClassWriter classWriter = new ClassWriter(0);
        classWriter.visit(49, 1, asmClassName, null, "java/lang/Object", null);
        AnnotationVisitor annotationVisitor = classWriter.visitAnnotation(DESC_OF_XML_ACCESSOR_TYPE, true);
        annotationVisitor.visitEnum("value", DESC_OF_XML_ACCESS_TYPE, "FIELD");
        annotationVisitor.visitEnd();
        for (Map.Entry entry : recordType.getFieldTypes().entrySet()) {
            String fieldName = (String)entry.getKey();
            Type fieldType = (Type)entry.getValue();
            Class<?> fieldTypeClass = this.loadClass(fieldType);
            String desc = org.objectweb.asm.Type.getDescriptor(fieldTypeClass);
            classWriter.visitField(1, fieldName, desc, null, null);
        }
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "<init>", "()V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(1, 1);
        methodVisitor.visitEnd();
        classWriter.visitEnd();
        return classWriter.toByteArray();
    }

    private byte[] createServiceEndpointInterfaceClass(ServiceEndpointInterfaceInfo serviceEndpointInterfaceInfo) throws ClassNotFoundException {
        org.objectweb.asm.Type returnType;
        String serviceEndpointInterfaceClassName = EgovWebServiceClassLoaderImpl.getServiceEndpointInterfaceClassName(serviceEndpointInterfaceInfo.getServiceName());
        String asmServiceEndpointInterfaceClassName = serviceEndpointInterfaceClassName.replace('.', '/');
        ClassWriter classWriter = new ClassWriter(0);
        classWriter.visit(49, 1537, asmServiceEndpointInterfaceClassName, null, "java/lang/Object", null);
        AnnotationVisitor annotationVisitor = classWriter.visitAnnotation(DESC_OF_WEB_SERVICE, true);
        annotationVisitor.visit("targetNamespace", (Object)serviceEndpointInterfaceInfo.getNamespace());
        annotationVisitor.visitEnd();
        annotationVisitor = classWriter.visitAnnotation(DESC_OF_SOAP_BINDING, true);
        annotationVisitor.visitEnum("parameterStyle", DESC_OF_SOAP_BINDING_PARAMETER_STYLE, "BARE");
        ServiceParamInfo returnInfo = serviceEndpointInterfaceInfo.getReturnInfo();
        Collection<ServiceParamInfo> paramInfos = serviceEndpointInterfaceInfo.getParamInfos();
        StringBuffer desc = new StringBuffer("(");
        StringBuffer signature = new StringBuffer("(");
        for (ServiceParamInfo info : paramInfos) {
            Class<Object> paramClass = this.loadClass(info.getType());
            org.objectweb.asm.Type paramType = org.objectweb.asm.Type.getType(paramClass);
            String paramSign = paramType.getDescriptor();
            if (info.getMode().equals((Object)WebParam.Mode.OUT) || info.getMode().equals((Object)WebParam.Mode.INOUT)) {
                if (paramClass.isPrimitive()) {
                    paramClass = wrapperClasses.get(paramClass);
                    paramType = org.objectweb.asm.Type.getType(paramClass);
                    paramSign = paramType.getDescriptor();
                }
                paramClass = Holder.class;
                paramType = TYPE_OF_HOLDER;
                paramSign = "Ljavax/xml/ws/Holder<" + paramSign + ">;";
            }
            desc.append(paramType.getDescriptor());
            signature.append(paramSign);
        }
        desc.append(")");
        signature.append(")");
        returnType = returnInfo == null ? (returnType = org.objectweb.asm.Type.VOID_TYPE) : org.objectweb.asm.Type.getType(this.loadClass(returnInfo.getType()));
        desc.append(returnType.getDescriptor());
        signature.append(returnType.getDescriptor());
        MethodVisitor methodVisitor = classWriter.visitMethod(1025, serviceEndpointInterfaceInfo.getOperationName(), desc.toString(), signature.toString(), null);
        annotationVisitor = methodVisitor.visitAnnotation(DESC_OF_WEB_METHOD, true);
        annotationVisitor.visit("operationName", (Object)serviceEndpointInterfaceInfo.getOperationName());
        annotationVisitor.visitEnd();
        if (returnInfo != null) {
            annotationVisitor = methodVisitor.visitAnnotation(DESC_OF_WEB_RESULT, true);
            annotationVisitor.visit("name", (Object)returnInfo.getName());
            annotationVisitor.visit("header", (Object)returnInfo.isHeader());
            annotationVisitor.visit("targetNamespace", (Object)serviceEndpointInterfaceInfo.getNamespace());
            annotationVisitor.visitEnd();
        }
        int index = 0;
        for (ServiceParamInfo info : serviceEndpointInterfaceInfo.getParamInfos()) {
            annotationVisitor = methodVisitor.visitParameterAnnotation(index, DESC_OF_WEB_PARAM, true);
            annotationVisitor.visit("name", (Object)info.getName());
            annotationVisitor.visitEnum("mode", DESC_OF_WEB_PARAM_MODE, info.getMode().toString());
            annotationVisitor.visit("header", (Object)info.isHeader());
            annotationVisitor.visit("targetNamespace", (Object)serviceEndpointInterfaceInfo.getNamespace());
            annotationVisitor.visitEnd();
            ++index;
        }
        methodVisitor.visitEnd();
        classWriter.visitEnd();
        return classWriter.toByteArray();
    }

    private byte[] createServiceEndpointClass(ServiceEndpointInfo serviceEndpointInfo) throws ClassNotFoundException {
        org.objectweb.asm.Type returnType;
        String serviceEndpointInterfaceClassName = EgovWebServiceClassLoaderImpl.getServiceEndpointInterfaceClassName(serviceEndpointInfo.getServiceName());
        String serviceEndpointClassName = EgovWebServiceClassLoaderImpl.getServiceEndpointClassName(serviceEndpointInfo.getServiceName());
        String asmServiceEndpointInterfaceClassName = serviceEndpointInterfaceClassName.replace('.', '/');
        String asmServiceEndpointClassName = serviceEndpointClassName.replace('.', '/');
        ClassWriter classWriter = new ClassWriter(0);
        classWriter.visit(49, 1, asmServiceEndpointClassName, null, "java/lang/Object", new String[]{asmServiceEndpointInterfaceClassName});
        AnnotationVisitor annotationVisitor = classWriter.visitAnnotation(DESC_OF_WEB_SERVICE, true);
        annotationVisitor.visit("endpointInterface", (Object)serviceEndpointInterfaceClassName);
        annotationVisitor.visit("targetNamespace", (Object)serviceEndpointInfo.getNamespace());
        annotationVisitor.visit("serviceName", (Object)serviceEndpointInfo.getServiceName());
        annotationVisitor.visit("portName", (Object)serviceEndpointInfo.getPortName());
        annotationVisitor.visitEnd();
        FieldVisitor fieldVisitor = classWriter.visitField(1, FIELD_NAME_OF_SERVICE_BRIDGE, DESC_OF_SERVICE_BRIDGE_CLASS, null, null);
        fieldVisitor.visitEnd();
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "<init>", "()V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(1, 1);
        methodVisitor.visitEnd();
        ServiceParamInfo returnInfo = serviceEndpointInfo.getReturnInfo();
        Collection<ServiceParamInfo> paramInfos = serviceEndpointInfo.getParamInfos();
        StringBuffer desc = new StringBuffer("(");
        StringBuffer signature = new StringBuffer("(");
        for (ServiceParamInfo info : paramInfos) {
            Class<Object> paramClass = this.loadClass(info.getType());
            org.objectweb.asm.Type paramType = org.objectweb.asm.Type.getType(paramClass);
            String paramSign = paramType.getDescriptor();
            if (info.getMode().equals((Object)WebParam.Mode.OUT) || info.getMode().equals((Object)WebParam.Mode.INOUT)) {
                if (paramClass.isPrimitive()) {
                    paramClass = wrapperClasses.get(paramClass);
                    paramType = org.objectweb.asm.Type.getType(paramClass);
                    paramSign = paramType.getDescriptor();
                }
                paramClass = Holder.class;
                paramType = TYPE_OF_HOLDER;
                paramSign = "Ljavax/xml/ws/Holder<" + paramSign + ">;";
            }
            desc.append(paramType.getDescriptor());
            signature.append(paramSign);
        }
        desc.append(")");
        signature.append(")");
        returnType = returnInfo == null ? (returnType = org.objectweb.asm.Type.VOID_TYPE) : org.objectweb.asm.Type.getType(this.loadClass(returnInfo.getType()));
        desc.append(returnType.getDescriptor());
        signature.append(returnType.getDescriptor());
        methodVisitor = classWriter.visitMethod(1, serviceEndpointInfo.getOperationName(), desc.toString(), signature.toString(), null);
        int mapPosition = paramInfos.size() + 1;
        methodVisitor.visitCode();
        methodVisitor.visitTypeInsn(187, "java/util/HashMap");
        methodVisitor.visitInsn(89);
        methodVisitor.visitMethodInsn(183, "java/util/HashMap", "<init>", "()V");
        methodVisitor.visitVarInsn(58, mapPosition);
        int i = 1;
        for (ServiceParamInfo info : paramInfos) {
            methodVisitor.visitVarInsn(25, mapPosition);
            methodVisitor.visitLdcInsn((Object)info.getName());
            methodVisitor.visitVarInsn(25, i);
            methodVisitor.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            methodVisitor.visitInsn(87);
            ++i;
        }
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, asmServiceEndpointClassName, FIELD_NAME_OF_SERVICE_BRIDGE, DESC_OF_SERVICE_BRIDGE_CLASS);
        methodVisitor.visitVarInsn(25, mapPosition);
        methodVisitor.visitMethodInsn(185, NAME_OF_SERVICE_BRIDGE_CLASS, "doService", "(Ljava/util/Map;)Ljava/lang/Object;");
        if (returnInfo != null) {
            methodVisitor.visitTypeInsn(192, returnType.getInternalName());
            methodVisitor.visitInsn(176);
        } else {
            methodVisitor.visitInsn(87);
            methodVisitor.visitInsn(177);
        }
        methodVisitor.visitMaxs(paramInfos.size(), paramInfos.size() + 2);
        methodVisitor.visitEnd();
        classWriter.visitEnd();
        return classWriter.toByteArray();
    }

    private static String getRecordTypeClassName(String recordTypeName) {
        return CLASS_NAME_PREFIX + recordTypeName;
    }

    private static String getServiceEndpointClassName(String serviceName) {
        return CLASS_NAME_PREFIX + serviceName + SERVICE_ENDPOINT_CLASS_NAME_POSTFIX;
    }

    private static String getServiceEndpointInterfaceClassName(String serviceName) {
        return CLASS_NAME_PREFIX + serviceName + SERVICE_ENDPOINT_INTERFACE_CLASS_NAME_POSTFIX;
    }
}

