/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.itl.webservice.service.impl;

import egovframework.rte.itl.integration.type.ListType;
import egovframework.rte.itl.integration.type.PrimitiveType;
import egovframework.rte.itl.integration.type.RecordType;
import egovframework.rte.itl.integration.type.Type;
import egovframework.rte.itl.webservice.service.EgovWebServiceClassLoader;
import egovframework.rte.itl.webservice.service.MessageConverter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageConverterImpl
implements MessageConverter {
    private Log LOG = LogFactory.getLog(this.getClass());
    private EgovWebServiceClassLoader classLoader;

    public MessageConverterImpl(EgovWebServiceClassLoader classLoader) {
        if (classLoader == null) {
            throw new IllegalArgumentException();
        }
        this.classLoader = classLoader;
    }

    public Object convertToValueObject(Object source, Type type) throws ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchFieldException {
        this.LOG.debug((Object)("convertToValueObject(source = " + source + ", type = " + type + ")"));
        if (type instanceof PrimitiveType) {
            this.LOG.debug((Object)"Type is a Primitive Type");
            return source;
        }
        if (type instanceof ListType) {
            this.LOG.debug((Object)"Type is a List Type");
            ListType listType = (ListType)type;
            Object[] components = ((Collection)source).toArray();
            Class<?> arrayClass = this.classLoader.loadClass((Type)listType);
            Object array = Array.newInstance(arrayClass.getComponentType(), components.length);
            for (int i = 0; i < components.length; ++i) {
                Array.set(array, i, this.convertToValueObject(components[i], listType.getElementType()));
            }
            return array;
        }
        if (type instanceof RecordType) {
            this.LOG.debug((Object)"Type is a Record(Map) Type");
            RecordType recordType = (RecordType)type;
            Map map = (Map)source;
            Class<?> recordClass = this.classLoader.loadClass((Type)recordType);
            Object record = recordClass.newInstance();
            for (Map.Entry entry : map.entrySet()) {
                Object fieldValue = this.convertToValueObject(entry.getValue(), recordType.getFieldType((String)entry.getKey()));
                recordClass.getField((String)entry.getKey()).set(record, fieldValue);
            }
            return record;
        }
        this.LOG.error((Object)"Type is invalid");
        throw new InstantiationException();
    }

    public Object convertToTypedObject(Object source, Type type) throws ClassNotFoundException, IllegalAccessException, NoSuchFieldException, InstantiationException {
        this.LOG.debug((Object)("convertToTypedObject(source = " + source + ", type = " + type + ")"));
        if (type instanceof PrimitiveType) {
            this.LOG.debug((Object)"Type is a Primitive Type");
            return source;
        }
        if (type instanceof ListType) {
            this.LOG.debug((Object)"Type is a List Type");
            ListType listType = (ListType)type;
            Object[] components = (Object[])source;
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object component : components) {
                list.add(this.convertToTypedObject(component, listType.getElementType()));
            }
            return list;
        }
        if (type instanceof RecordType) {
            this.LOG.debug((Object)"Type is a Record(Map) Type");
            RecordType recordType = (RecordType)type;
            Class<?> recordClass = this.classLoader.loadClass((Type)recordType);
            HashMap map = new HashMap();
            for (Map.Entry entry : recordType.getFieldTypes().entrySet()) {
                Object fieldValue = recordClass.getField((String)entry.getKey()).get(source);
                map.put(entry.getKey(), this.convertToTypedObject(fieldValue, (Type)entry.getValue()));
            }
            return map;
        }
        this.LOG.error((Object)"Type is invalid");
        throw new InstantiationException();
    }
}

