/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.fdl.cryptography.impl;

import egovframework.rte.fdl.cryptography.EgovARIACryptoService;
import egovframework.rte.fdl.cryptography.EgovPasswordEncoder;
import egovframework.rte.fdl.cryptography.impl.ARIACipher;
import egovframework.rte.fdl.logging.util.EgovResourceReleaser;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigDecimal;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

public class EgovARIACryptoServiceImpl
implements EgovARIACryptoService {
    private final Base64 base64 = new Base64();
    private static final Logger LOGGER = LoggerFactory.getLogger(EgovARIACryptoServiceImpl.class);
    private static final int DEFAULT_BLOCKSIZE = 1024;
    private static final int BLOCKSIZE_MODULAR = 16;
    private EgovPasswordEncoder passwordEncoder;
    private int blockSize = 1024;

    @Override
    @Required
    public void setPasswordEncoder(EgovPasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
        LOGGER.debug("passwordEncoder's algorithm : {}", (Object)passwordEncoder.getAlgorithm());
    }

    @Override
    public void setBlockSize(int blockSize) {
        if (blockSize % 16 != 0) {
            blockSize += 16 - blockSize % 16;
        }
        this.blockSize = blockSize;
    }

    @Override
    public BigDecimal encrypt(BigDecimal number, String password) {
        throw new UnsupportedOperationException("Unsupported method.. (ARIA Cryptography service doesn't support BigDecimal en/decryption)");
    }

    @Override
    public byte[] encrypt(byte[] data, String password) {
        if (this.passwordEncoder.checkPassword(password)) {
            ARIACipher cipher = new ARIACipher();
            cipher.setPassword(password);
            return cipher.encrypt(data);
        }
        LOGGER.error("password not matched!!!");
        throw new IllegalArgumentException("password not matched!!!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encrypt(File srcFile, String password, File trgtFile) throws FileNotFoundException, IOException {
        BufferedWriter bw;
        BufferedInputStream bis;
        FileWriter fw;
        FileInputStream fis;
        block8: {
            block7: {
                fis = null;
                fw = null;
                bis = null;
                bw = null;
                byte[] buffer = null;
                if (!this.passwordEncoder.checkPassword(password)) break block7;
                ARIACipher cipher = new ARIACipher();
                cipher.setPassword(password);
                buffer = new byte[this.blockSize];
                LOGGER.debug("blockSize = {}", (Object)this.blockSize);
                try {
                    fis = new FileInputStream(srcFile);
                    bis = new BufferedInputStream(fis);
                    fw = new FileWriter(trgtFile);
                    bw = new BufferedWriter(fw);
                    byte[] encrypted = null;
                    int length = 0;
                    long size = 0L;
                    while ((length = bis.read(buffer)) >= 0) {
                        String line;
                        if (length < this.blockSize) {
                            byte[] tmp = new byte[length];
                            System.arraycopy(buffer, 0, tmp, 0, length);
                            encrypted = cipher.encrypt(tmp);
                        } else {
                            encrypted = cipher.encrypt(buffer);
                        }
                        try {
                            line = new String(this.base64.encode(encrypted), "US-ASCII");
                        }
                        catch (Exception ee) {
                            throw new RuntimeException(ee);
                        }
                        bw.write(line);
                        bw.newLine();
                        size += (long)length;
                    }
                    bw.flush();
                    LOGGER.debug("processed bytes = {}", (Object)size);
                }
                catch (Throwable throwable) {
                    EgovResourceReleaser.close((Closeable[])new Closeable[]{fw, bw, fis, bis});
                    throw throwable;
                }
                break block8;
            }
            LOGGER.error("password not matched!!!");
            throw new IllegalArgumentException("password not matched!!!");
        }
        EgovResourceReleaser.close((Closeable[])new Closeable[]{fw, bw, fis, bis});
    }

    @Override
    public BigDecimal decrypt(BigDecimal encryptedNumber, String password) {
        throw new UnsupportedOperationException("Unsupported method.. (ARIA Cryptography service doesn't support BigDecimal en/decryption)");
    }

    @Override
    public byte[] decrypt(byte[] encryptedData, String password) {
        if (this.passwordEncoder.checkPassword(password)) {
            ARIACipher cipher = new ARIACipher();
            cipher.setPassword(password);
            return cipher.decrypt(encryptedData);
        }
        LOGGER.error("password not matched!!!");
        throw new IllegalArgumentException("password not matched!!!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decrypt(File encryptedFile, String password, File trgtFile) throws FileNotFoundException, IOException {
        BufferedOutputStream bos;
        BufferedReader br;
        FileOutputStream fos;
        FileReader fr;
        block6: {
            block5: {
                fr = null;
                fos = null;
                br = null;
                bos = null;
                if (!this.passwordEncoder.checkPassword(password)) break block5;
                ARIACipher cipher = new ARIACipher();
                cipher.setPassword(password);
                try {
                    fr = new FileReader(encryptedFile);
                    br = new BufferedReader(fr);
                    fos = new FileOutputStream(trgtFile);
                    bos = new BufferedOutputStream(fos);
                    byte[] encrypted = null;
                    byte[] decrypted = null;
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        try {
                            encrypted = this.base64.decode(line.getBytes("US-ASCII"));
                        }
                        catch (Exception de) {
                            throw new RuntimeException(de);
                        }
                        decrypted = cipher.decrypt(encrypted);
                        bos.write(decrypted);
                    }
                    bos.flush();
                }
                catch (Throwable throwable) {
                    EgovResourceReleaser.close((Closeable[])new Closeable[]{fos, bos, fr, br});
                    throw throwable;
                }
                break block6;
            }
            LOGGER.error("password not matched!!!");
            throw new IllegalArgumentException("password not matched!!!");
        }
        EgovResourceReleaser.close((Closeable[])new Closeable[]{fos, bos, fr, br});
    }
}

