/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.fdl.idgnr.impl;

import egovframework.rte.fdl.cmmn.exception.FdlException;
import egovframework.rte.fdl.idgnr.impl.AbstractDataBlockIdGnrService;
import java.math.BigDecimal;
import java.util.Locale;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class EgovTableIdGnrService
extends AbstractDataBlockIdGnrService {
    private static final Logger LOGGER = LoggerFactory.getLogger(EgovTableIdGnrService.class);
    private String table = "ids";
    private String tableName = "id";
    private String tableNameFieldName = "table_name";
    private String nextIdFieldName = "next_id";
    private JdbcTemplate jdbcTemplate;
    private TransactionTemplate transactionTemplate;

    @Override
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        DataSourceTransactionManager transactionManager = new DataSourceTransactionManager(dataSource);
        this.transactionTemplate = new TransactionTemplate((PlatformTransactionManager)transactionManager);
        this.transactionTemplate.setPropagationBehaviorName("PROPAGATION_REQUIRES_NEW");
        this.transactionTemplate.setIsolationLevelName("ISOLATION_READ_COMMITTED");
    }

    private Object insertInitId(boolean useBigDecimals, int blockSize) {
        LOGGER.debug(this.messageSource.getMessage("debug.idgnr.init.idblock", new Object[]{this.tableName}, Locale.getDefault()));
        Number initId = null;
        String insertQuery = "INSERT INTO " + this.table + "(" + this.tableNameFieldName + ", " + this.nextIdFieldName + ") " + "values('" + this.tableName + "', ?)";
        LOGGER.debug("Insert Query : {}", (Object)insertQuery);
        initId = useBigDecimals ? new BigDecimal(blockSize) : new Long(blockSize);
        this.jdbcTemplate.update(insertQuery, new Object[]{initId});
        return initId;
    }

    private Object allocateIdBlock(final int blockSize, final boolean useBigDecimals) throws FdlException {
        LOGGER.debug(this.messageSource.getMessage("debug.idgnr.allocate.idblock", new Object[]{new Integer(blockSize), this.tableName}, Locale.getDefault()));
        try {
            return this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

                public Object doInTransaction(TransactionStatus status) {
                    Object nextId;
                    block11: {
                        try {
                            String selectQuery = "SELECT " + EgovTableIdGnrService.this.nextIdFieldName + " FROM " + EgovTableIdGnrService.this.table + " WHERE " + EgovTableIdGnrService.this.tableNameFieldName + " = ?";
                            LOGGER.debug("Select Query : {}", (Object)selectQuery);
                            if (useBigDecimals) {
                                try {
                                    nextId = EgovTableIdGnrService.this.jdbcTemplate.queryForObject(selectQuery, new Object[]{EgovTableIdGnrService.this.tableName}, BigDecimal.class);
                                }
                                catch (EmptyResultDataAccessException erdae) {
                                    nextId = null;
                                }
                                if (nextId == null) {
                                    EgovTableIdGnrService.this.insertInitId(useBigDecimals, blockSize);
                                    return new BigDecimal(0);
                                }
                                break block11;
                            }
                            try {
                                nextId = EgovTableIdGnrService.this.jdbcTemplate.queryForLong(selectQuery, new Object[]{EgovTableIdGnrService.this.tableName});
                            }
                            catch (EmptyResultDataAccessException erdae) {
                                nextId = -1L;
                            }
                            if ((Long)nextId == -1L) {
                                EgovTableIdGnrService.this.insertInitId(useBigDecimals, blockSize);
                                return new Long(0L);
                            }
                        }
                        catch (DataAccessException dae) {
                            dae.printStackTrace();
                            LOGGER.debug("{}", (Throwable)dae);
                            status.setRollbackOnly();
                            throw new RuntimeException(new FdlException(EgovTableIdGnrService.this.messageSource, "error.idgnr.select.idblock", (Object[])new String[]{EgovTableIdGnrService.this.tableName}, null));
                        }
                    }
                    try {
                        String updateQuery = "UPDATE " + EgovTableIdGnrService.this.table + " SET " + EgovTableIdGnrService.this.nextIdFieldName + " = ?" + " WHERE " + EgovTableIdGnrService.this.tableNameFieldName + " = ?";
                        LOGGER.debug("Update Query : {}", (Object)updateQuery);
                        Number newNextId = useBigDecimals ? ((BigDecimal)nextId).add(new BigDecimal(blockSize)) : new Long((Long)nextId + (long)blockSize);
                        EgovTableIdGnrService.this.jdbcTemplate.update(updateQuery, new Object[]{newNextId, EgovTableIdGnrService.this.tableName});
                        return nextId;
                    }
                    catch (DataAccessException dae) {
                        status.setRollbackOnly();
                        throw new RuntimeException(new FdlException(EgovTableIdGnrService.this.messageSource, "error.idgnr.update.idblockk", (Object[])new String[]{EgovTableIdGnrService.this.tableName}, null));
                    }
                }
            });
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof FdlException) {
                throw (FdlException)re.getCause();
            }
            throw re;
        }
    }

    @Override
    protected BigDecimal allocateBigDecimalIdBlock(int blockSize) throws FdlException {
        return (BigDecimal)this.allocateIdBlock(blockSize, true);
    }

    @Override
    protected long allocateLongIdBlock(int blockSize) throws FdlException {
        Long id = (Long)this.allocateIdBlock(blockSize, false);
        return id;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setTableNameFieldName(String tableNameFieldName) {
        this.tableNameFieldName = tableNameFieldName;
    }

    public void setNextIdFieldName(String nextIdFieldName) {
        this.nextIdFieldName = nextIdFieldName;
    }
}

